package com.baidu.bigpipe.protocol;

/**
 * 服务端推送过来的消息对象，包含原始的二进制消息以及这个消息在bigpipe中的存储信息
 */
public class QueueMessage extends McpackCommand {
    private int err_no;

    // all fields below are optional
    private String err_msg;
    private String pipe_name;
    private int pipelet_id;
    private long pipelet_msg_id;
    private int seq_id;
    private byte[] msg_body;
    private long srvtime;
    private int timeout;

    /**
     * 标记是否是fake message，非0为fake message
     */
    private int msg_flag;

    /**
     * @return 0为没有错误，其他为对应的错误码
     */
    public int getErr_no() {
        return err_no;
    }
    public void setErr_no(int err_no) {
        this.err_no = err_no;
    }
    public String getErr_msg() {
        return err_msg;
    }
    public void setErr_msg(String err_msg) {
        this.err_msg = err_msg;
    }
    public String getPipe_name() {
        return pipe_name;
    }
    public void setPipe_name(String pipe_name) {
        this.pipe_name = pipe_name;
    }

    /**
     * pipeletid从0开始；区别于pipelet名的后缀是从1开始的
     * @return
     */
    public int getPipelet_id() {
        return pipelet_id;
    }
    public void setPipelet_id(int pipelet_id) {
        this.pipelet_id = pipelet_id;
    }

    /**
     * 消息在bigpipe中的存储位置，对应订阅api的订阅点
     * @return 64位整型
     */
    public long getPipelet_msg_id() {
        return pipelet_msg_id;
    }
    public void setPipelet_msg_id(long pipelet_msg_id) {
        this.pipelet_msg_id = pipelet_msg_id;
    }

    /**
     * 消息在一个包中的编号，对于bigpipe4j来说不打包，为1
     * @return
     */
    public int getSeq_id() {
        return seq_id;
    }
    public void setSeq_id(int seq_id) {
        this.seq_id = seq_id;
    }
    /**
     * @return 原始的二进制消息内容
     */
    public byte[] getMsg_body() {
        return msg_body;
    }
    public void setMsg_body(byte[] msg_body) {
        this.msg_body = msg_body;
    }
    public long getSrvtime() {
        return srvtime;
    }
    public void setSrvtime(long srvtime) {
        this.srvtime = srvtime;
    }
    public int getTimeout() {
        return timeout;
    }
    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
    /**
     * 是否是fake消息
     * @return 返回非0为fake消息
     */
    public int getMsg_flag() {
        return msg_flag;
    }
    public void setMsg_flag(int msg_flag) {
        this.msg_flag = msg_flag;
    }
}
