package com.baidu.bigpipe.protocol;

import java.util.concurrent.atomic.AtomicLong;

/**
 * LogIdGen的缺省实现,在内存中从1原子性的累加,线程安全,但jvm重启后会从1重新累加
 * 
 * @author hexiufeng
 * 
 */
public class SequenceLogIdGen implements LogIdGen {
    private AtomicLong counter = new AtomicLong(0);

    @Override
    public long genId() {
        long v = counter.incrementAndGet();
        if (v < 0) {
            v &= Long.MAX_VALUE;
        }
        if (v == 0) {
            return genId();
        }
        return v;
    }

}
