package com.baidu.bigpipe.protocol.meta;

/**
 * 缺省的PipeletInstanceRoleSelectStrategy实现,策略是：<br>
 * <ul>
 *  <li> 可以从主、从实例订阅，但优先从实例订阅 </li>
 *  <li> 使用权重控制 </li>
 * </ul>
 * 
 * 
 * @author hexiufeng
 * 
 */
public class DefaultPipeletInstanceRoleStrategy implements PipeletInstanceRoleSelectStrategy {
    /**
     * 这里不用考虑线程问题，除了初始化，其他重新连接bigpipe操作都发生在单线程中
     */
    private int index = 0;
    private int count = 0;

    private final int[] roles = new int[] { PipeletInstanceRoleSelectStrategy.SLAVE_ROLE,
            PipeletInstanceRoleSelectStrategy.MASTER_ROLE };
    /**
     * 订阅主要从pipelet的从实例中订阅，只有从实例都崩溃时才从主实例中订阅，使用权重方式实现，
     * 主从权重比时99:1
     */
    private final int[] weights = new int[] { 99, 1 };

    @Override
    public int getCurrentRole() {
        if (count == weights[index]) {
            index = (index + 1) % roles.length;
            count = 0;
        }
        ++count;
        return roles[index];
    }
}
