package com.baidu.bigpipe.protocol.meta;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

/**
 * bigpipe meta信息的加载器,可能是从zookeeper加载，也可能是从文件中加载
 *
 * @author hexiufeng
 */
public interface MetaLoader {
    /**
     * /** 从指定的路径中加载meta data
     *
     * @param path zk path
     *
     * @return string data
     *
     * @throws KeeperException KeeperException
     */
    String getMeta(String path) throws KeeperException;

    /**
     * 获取zookeeper节点的信息，可以用来判断节点是否存在
     * <p>在zk没完成连接或者是丢失连接等情况下抛出异常；</p>
     * <p>节点不存在将返回null</p>
     *
     * @param path zookeeper路径
     *
     * @return 返回节点的Stat对象
     *
     * @throws KeeperException
     * @throws InterruptedException
     */
    public Stat stat(String path) throws KeeperException, InterruptedException;

    /**
     * 获取zookeeper节点的数据
     * 在zk没完成连接或者是丢失连接等情况下抛出异常；在节点有问题（如不存在）的情况下抛出异常
     * <p>本方法无状态，可以多线程访问</p>
     *
     * @param path zookeeper路径
     *
     * @return 返回节点所存储的二进制数据
     *
     * @throws InterruptedException
     * @throws KeeperException
     */
    public byte[] get(String path) throws KeeperException, InterruptedException;

}
