package com.baidu.bigpipe.protocol.meta;

/**
 * pipelet实例确定策略,只用于消费。 从zk中获取要从哪个具体的pipelet实例中订阅消息时，要指定需要的实例的角色。
 * 
 * @author hexiufeng
 * 
 */
public interface PipeletInstanceRoleSelectStrategy {
    /**
     * master
     */
    int MASTER_ROLE = 1;
    /**
     * slave
     */
    int SLAVE_ROLE = 2;

    /**
     * 获取当前需要的pipelet实例的角色
     * 
     * @return 当前的角色,返回以下值：<br>
     *         <ul>
     *         <li>{@link PipeletInstanceRoleSelectStrategy#MASTER_ROLE}</li>
     *         <li>{@link PipeletInstanceRoleSelectStrategy#SLAVE_ROLE}</li>
     *         </ul>
     */
    int getCurrentRole();
}
