package com.baidu.bigpipe.protocol.meta.exp;

/**
 * 从zookeeper中按照名字解析pipelet地址出错异常
 * 
 * @author hexiufeng
 * 
 */
public class NameResolveException extends Exception {
    private static final long serialVersionUID = 6066322969565260318L;

    private String pipeletName;
    private long startpoint;

    public String getPipeletName() {
        return pipeletName;
    }

    public void setPipeletName(String pipeletName) {
        this.pipeletName = pipeletName;
    }

    public long getStartpoint() {
        return startpoint;
    }

    public void setStartpoint(long startpoint) {
        this.startpoint = startpoint;
    }

    /**
     * 构造方法
     * 
     * @param pipeletName piplet名称
     * @param startpoint 起始点
     * @param msg 出错信息
     */
    public NameResolveException(String pipeletName, long startpoint, String msg) {
        super(msg);
        this.pipeletName = pipeletName;
        this.startpoint = startpoint;
    }

    /**
     * 构造方法
     * 
     * @param pipeletName piplet名称
     * @param startpoint 起始点
     * @param msg 出错信息
     * @param e 原始异常
     */
    public NameResolveException(String pipeletName, long startpoint, String msg, Exception e) {
        super(msg, e);
        this.pipeletName = pipeletName;
        this.startpoint = startpoint;
    }
}
