package com.baidu.bigpipe.protocol.meta.exp;

/**
 * 无法解析queue名称到对应的queuesvr地址时抛出此异常
 */
public class QueueLocateException extends Exception {
    private static final long serialVersionUID = 5541038328076472661L;

    private String queueName;

    public QueueLocateException(Exception exception) {
        super("locate queue failed.", exception);
    }

    public QueueLocateException(String queueName, String message, Exception exception) {
        super("locate queue " + queueName + " failed: " + message, exception);
        this.queueName = queueName;
    }

    public String getQueueName() {
        return queueName;
    }
}
