package com.baidu.bigpipe.protocol.meta.exp;

/**
 * stripe信息异常
 * 
 * @author hexiufeng
 *
 */
public class StripeOffsetException extends NameResolveException {
    private static final long serialVersionUID = 1632017239727674430L;

    /**
     * 构造方法
     * 
     * @param pipeletName pipelet Name
     * @param startpoint 起始点
     * @param minoffset 上一个stripe起始点
     */
    public StripeOffsetException(String pipeletName,
            long startpoint, long minoffset) {
        super(pipeletName, startpoint,
                "stripe offset " + startpoint
                +" is out of range[" + minoffset + ", " + Long.MAX_VALUE + ")");
    }

}
