/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the BAIDU
 */
package com.baidu.bigpipe.spring.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.baidu.bigpipe.driver.DefaultListenerSubscriber;
import com.baidu.bigpipe.driver.NoneBlockingBigpipePubClient;
import com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter;
import com.baidu.bigpipe.driver.converter.sub.StringMessageBodyConverter;
import com.baidu.bigpipe.position.store.SubcribePositionStore;
import com.baidu.bigpipe.transport.conf.BigPipeConf;

/**
 * Annotation that marks a field type to be the target of a Bigpipe message
 * listener.<br>
 * Note the target field must be implements {@link NoneBlockingBigpipePubClient}
 * interface.
 * 
 * @author xiemalin
 * 
 */
@Target({ ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface MessageListener {

	/**
	 * set the name of pipelet. this set will override the value from
	 * bigPipeConf bean.
	 * 
	 * @see #bigPipeConf()
	 */
	String pipeletName() default "";

	/**
	 * The bean name of the {@link BigPipeConf} to use create
	 * {@link DefaultListenerSubscriber} on initialize.
	 */
	String bigPipeConf() default "bigPipeConf";

	/**
	 * set the name of bigpipe cluster. this set will override the value from
	 * bigPipeConf bean.
	 * 
	 * @see #bigPipeConf()
	 */
	String cluster() default "";

	/**
	 * set the target pipelet id this set will override the value from
	 * bigPipeConf bean.
	 * 
	 * @see #bigPipeConf()
	 */
	String pipeletId() default "";

	/**
	 * The bean name of the {@link SubcribePositionStore} implements for the
	 * start with position to receive data<br>
	 * if not set will use remote message position by session id.
	 */
	String subcribePositionStore() default "localFileSubcribePositionStore";

	/**
	 * The bean name of the {@link MessageBodyConverter} implementation. defalut
	 * will use {@link StringMessageBodyConverter}
	 * 
	 * @see DefaultListenerSubscriber
	 * @see StringMessageBodyConverter
	 */
	String bodyConverter() default "";

}
