/*
 * Copyright 2015 the original author or authors.
 *
 * Licensed under the BAIDU
 */
package com.baidu.bigpipe.spring.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.baidu.bigpipe.driver.DefaultListenerSubscriber;
import com.baidu.bigpipe.driver.NoneBlockingBigpipePubClient;
import com.baidu.bigpipe.transport.conf.BigPipeConf;

/**
 * Annotation that marks a class field to be the target of a Bigpipe message sender.<br>
 * Note the target class field must be implements {@link NoneBlockingBigpipePubClient} interface.
 * 
 * @author xiemalin
 * 
 */
@Target({ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface MessageSender {

	/**
	 * set the name of pipelet. this set will override the value from bigPipeConf bean.
	 * @see #bigPipeConf()
	 */
	String pipeletName() default "";
	
	/**
	 * The bean name of the {@link BigPipeConf} to use create {@link DefaultListenerSubscriber} on initialize. 
	 */
	String bigPipeConf();
	
	/**
	 * set the name of bigpipe cluster. this set will override the value from bigPipeConf bean.
	 * @see #bigPipeConf()
	 */	
	String cluster() default "";
	
	
	/**
	 * set the target pipelet id  this set will override the value from bigPipeConf bean.
	 * @see #bigPipeConf()
	 */
	String pipeletId() default "";
	
	
}
