package com.baidu.bigpipe.tool;

public class BinaryTool {

    public static void copyIntegerToBuffer(int n, byte[] buffer, int offset) {
        if (buffer.length < offset + 4) {
            throw new ArrayIndexOutOfBoundsException(
                    "写入buffer错误,指定下标offset加上写入int字节长度超过byte数组的总长度,"
                            + "当前byte数组长度:" + buffer.length + ",写入位置:" + offset);
        }
        buffer[offset] = (byte) (n & 0xff);
        buffer[offset + 1] = (byte) ((n >> 8) & 0xff);
        buffer[offset + 2] = (byte) ((n >> 16) & 0xff);
        buffer[offset + 3] = (byte) ((n >> 24) & 0xff);
    }

    public static int calcBufferToInteger(byte[] buffer, int offset) {
        if (buffer.length < offset + 4) {
            throw new ArrayIndexOutOfBoundsException(
                    "读取错误,指定下标offset加上读取int的字节长度超过byte数组的总长度,"
                            + "当前byte数组长度:" + buffer.length + ",读取位置:" + offset);
        }
        return ((buffer[offset + 3] & 0xff) << 24)
                + ((buffer[offset + 2] & 0xff) << 16)
                + ((buffer[offset + 1] & 0xff) << 8)
                + (buffer[offset] & 0xff);
    }

    public static void copyShortToBuffer(short n, byte[] buffer, int offset) {
        if (buffer.length < offset + 2) {
            throw new ArrayIndexOutOfBoundsException(
                    "写入buffer错误,指定下标offset加上写入short字节长度超过byte数组的总长度,"
                            + "当前byte数组长度:" + buffer.length + ",写入位置:" + offset);
        }
        buffer[offset] = (byte) (n & 0xff);
        buffer[offset + 1] = (byte) ((n >> 8) & 0xff);
    }

    public static short calcBufferToShort(byte[] buffer, int offset) {
        if (buffer.length < offset + 2) {
            throw new ArrayIndexOutOfBoundsException(
                    "读取错误,指定下标offset加上读取short的字节长度超过byte数组的总长度,"
                            + "当前byte数组长度:" + buffer.length + ",读取位置:" + offset);
        }
        return (short) (((buffer[offset + 1] & 0xff) << 8) + (buffer[offset] & 0xff));
    }
}
