package com.baidu.bigpipe.transport;

import java.util.concurrent.CountDownLatch;

/**
 * 描述消息发布或者消息订阅的生命周期
 * 
 * @author hexiufeng
 * 
 */
public class LifeController {
    private volatile boolean shutDown = false;
    /**
     * 调用shutdown后，等待结束的控制器
     */
    private final CountDownLatch shutDownWait = new CountDownLatch(1);
    /**
     * 在上层调用init方法时启动线程时需要等待线程完成启动完成
     */
    private final CountDownLatch threadRunning = new CountDownLatch(1);
    
    public boolean isShutDown() {
        return shutDown;
    }
    public void setShutDown(boolean shutDown) {
        this.shutDown = shutDown;
    }
    public CountDownLatch getShutDownWait() {
        return shutDownWait;
    }
    public CountDownLatch getThreadRunning() {
        return threadRunning;
    }
}
