package com.baidu.bigpipe.transport;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Adler32;

import com.baidu.bigpipe.transport.conf.SocketConf;

/**
 * NsHead协议的网络传输策略实现，实现{@link com.baidu.bigpipe.transport.TransportStrategy TransStrategy}接口
 * 
 * @author hexiufeng
 * 
 */
public class NHeadTransportStrategy implements TransportStrategy {
    /**
     * nshead提供者为beidou-bigpipe
     */
    protected String provider = "baidu4j-bigpipe";
    /**
     * bigpipe规定的校验方式
     */
    protected final Adler32 checksum = new Adler32();
    /**
     * 常量，int型的数据的字节数
     */
    static final int INT_SIZE = 4;
    /**
     * socket 配置信息
     */
    protected SocketConf socketConf;

    @Override
    public ByteBuffer buildSimpleCommand(byte[] buf) {
        NSHead head = NSHead.factory(provider);
        head.setBodyLen(buf.length + INT_SIZE);

        byte[] pack = new byte[buf.length + INT_SIZE + NSHead.SIZE];

        ByteBuffer bbf = ByteBuffer.wrap(pack);
        bbf.order(ByteOrder.LITTLE_ENDIAN);
        bbf.position(NSHead.SIZE);
        bbf.putInt(buf.length);
        bbf.put(buf);

        // 需要校验最终数据
        checksum.update(pack, NSHead.SIZE, buf.length + INT_SIZE);
        head.setReserved((int) (checksum.getValue() & 0xffffffff));
        checksum.reset();
        System.arraycopy(head.toBytes(), 0, pack, 0, NSHead.SIZE);

        bbf.flip();
        return bbf;
    }

    @Override
    public String getProvider() {
        return provider;
    }

    @Override
    public void applySocketConf(SocketConf conf) {
        this.socketConf = conf;
    }
}
