package com.baidu.bigpipe.transport;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

import com.baidu.bigpipe.transport.pub.context.ReadContext;

/**
 * 基于 NsHead协议的数据接收器实现
 * 
 * @author hexiufeng1
 * 
 */
public class NsHeadReciever implements Receiver {
    
    @Override
    public void recieve(SocketChannel channel, ReadContext context) throws IOException {
        // 当前接收的数据是否是header部分
        if (context.getBuf() == null && context.isHeader()) {
            context.setBuf(ByteBuffer.allocate(NSHead.SIZE));
        }
        // 接收header数据
        if (context.isHeader()) {
            int cnt = channel.read(context.getBuf());
            if (cnt == SOCKET_EOF) {
                context.setEnd(true);
                return;
            }
            if (context.getBuf().remaining() > 0) {
                return;
            }
            NSHead head = NSHead.fromBytes(context.getBuf().array());
            // 获取body 长度，构建body buffer
            context.setBuf(ByteBuffer.allocate((int) head.getBodyLen()));
            context.setHeader(false);
        }
        int cnt = channel.read(context.getBuf());
        if (cnt == SOCKET_EOF) {
            context.setEnd(true);
            return;
        }
        if (context.getBuf().remaining() == 0) {
            context.setComplete(true);
        }
    }

    @Override
    public ByteBuffer blockRecieve(Socket socket) throws IOException {
        // read header data
        byte[] head = new byte[NSHead.SIZE];
        if (!blockRead(socket, head)) {
            return null;
        }
        NSHead nh = NSHead.fromBytes(head);
        byte[] buff = new byte[(int) nh.getBodyLen()];
        if (!blockRead(socket, buff)) {
            return null;
        }

        return ByteBuffer.wrap(buff);
    }

    /**
     * read data from socket and fill into buffer util thf buffer is full
     * 
     * @param socket 需要读取数据的socket对象
     * @param buffer 缓存数据的buffer
     * @return 是否读到数据
     * @throws IOException 网络io异常
     */
    private boolean blockRead(Socket socket, byte[] buffer) throws IOException {
        int remaining = buffer.length;
        while (remaining > 0) {
            int read = socket.getInputStream().read(buffer, buffer.length - remaining, remaining);
            if (read == SOCKET_EOF) {
                return false;
            }
            remaining -= read;
        }
        return true;
    }

}
