package com.baidu.bigpipe.transport;

import com.baidu.bigpipe.protocol.SessionIdProvider;
import com.baidu.bigpipe.protocol.meta.NameService;

/**
 * 包内使用，记录publisher中与pipe相关的运行时信息,包括：
 * <ul>
 * <li>pipelet相关信息的NameServie</li>
 * <li>pipelet相关信息的messageId</li>
 * <li>pipelet相关信息的topicName</li>
 * <li>socket断开时重连的最大次数</li>
 * </ul>
 * 
 * @author hexiufeng
 * 
 */
public final class PipeRuntime {
    NameService ns;
    SessionIdProvider sessionIdProvider;
    volatile long sessionMessageId;
    String topicName;
    String queueName;
    int reConnectMaxTimes;
    boolean refreshSessionId = false;
    
    public NameService getNs() {
        return ns;
    }
    public void setNs(NameService ns) {
        this.ns = ns;
    }
    public SessionIdProvider getSessionIdProvider() {
        return sessionIdProvider;
    }
    public void setSessionIdProvider(SessionIdProvider sessionIdProvider) {
        this.sessionIdProvider = sessionIdProvider;
    }
    public long getSessionMessageId() {
        return sessionMessageId;
    }
    public void setSessionMessageId(long sessionMessageId) {
        this.sessionMessageId = sessionMessageId;
    }
    public String getTopicName() {
        return topicName;
    }
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }
    public int getReConnectMaxTimes() {
        return reConnectMaxTimes;
    }
    public void setReConnectMaxTimes(int reConnectMaxTimes) {
        this.reConnectMaxTimes = reConnectMaxTimes;
    }
    public boolean isRefreshSessionId() {
        return refreshSessionId;
    }
    public void setRefreshSessionId(boolean refreshSessionId) {
        this.refreshSessionId = refreshSessionId;
    }
    public String getQueueName() {
        return queueName;
    }
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }
}
