package com.baidu.bigpipe.transport;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

import com.baidu.bigpipe.transport.pub.context.ReadContext;

/**
 * 从Socket中接收完整的消息数据的接收器
 * 
 * @author hexiufeng
 * 
 */
public interface Receiver {
    /**
     * Socket不能返回任何数据，一般是socket出现问题
     */
    int SOCKET_EOF = -1;

    /**
     * 从SocketChannel非堵塞模式接收数据,调用该方法不会堵塞，一次可能不能接收所有数据，需要多次才能接收完所有数据
     * 
     * @param channel
     * @param context
     * @throws IOException
     */
    void recieve(SocketChannel channel, ReadContext context) throws IOException;

    /**
     * 从Socket堵塞接收数据，调用该方法会堵塞，一次可能不能接收所有数据，需要多次才能接收完所有数据
     * 
     * @param socket
     * @return null表示socket eof
     * @throws IOException
     */
    ByteBuffer blockRecieve(Socket socket) throws IOException;
}
