package com.baidu.bigpipe.transport;

import java.nio.ByteBuffer;

import com.baidu.bigpipe.transport.conf.SocketConf;

/**
 * 与传输相关的策略抽象。 包括如下属性：
 * <ul>
 * <li>抽象构建bigpipe协议的command对象</li>
 * <li>提供NsHeader协议的提供者属性</li>
 * <li>应用socket配置</li>
 * </ul>
 * 
 * @author hexiufeng
 *
 */
public interface TransportStrategy {
    /**
     * 抽象构建bigpipe协议的command对象
     * @param buf
     * @return
     */
	ByteBuffer buildSimpleCommand(byte[] buf);
	/**
	 * 提供NsHeader协议的提供者属性
	 * @return
	 */
	String getProvider();
	/**
	 * 应用socket配置
	 * @param conf
	 */
	void applySocketConf(SocketConf conf);
}
