package com.baidu.bigpipe.transport.conf;

import com.baidu.bigpipe.protocol.SessionIdProvider;


/**
 * bigpipe的配置信息
 * 
 * @author work
 * 
 */
public class BigPipeConf extends SocketConf implements Cloneable {
    private String pipe;
    private int pipeletId;
    private String cluster;
    private String userName;
    private String pwd;
    private String pipeletName;
    private SessionIdProvider sessionProvider;
    // queue 的名字,订阅topic的时候不用填写
    private String queue;
    // 注意这里的token4Queue(通过邮件接收)跟pipelet的pwd(通过手动设置)是不一样的.订阅topic的时候不用填写
    private String token4Queue;
    // queue 的接收窗口大小,订阅topic的时候不用填写
    private int windowSize;
    /**
     * 内存中可缓存的任务的最大个数
     */
    private int maxCachedTask = 20000;
    /**
     * 获取bigpipe元数据所需要的zookeeper的url
     */
    private String metaString;

    private long defStartPoint = COULD_ZERO;

    // 表示pipe的position是从0开始
    public static final long COULD_ZERO = -2;
    // 表示pipe的position是Long.MAX_VALUE
    public static final long COUNT_MAX = -1;

    public long getDefStartPoint() {
        return defStartPoint;
    }

    public void setDefStartPoint(long defStartPoint) {
        this.defStartPoint = defStartPoint;
    }

    public String getMetaString() {
        return metaString;
    }

    public void setMetaString(String metaString) {
        this.metaString = metaString;
    }

    public String getPipe() {
        return pipe;
    }

    public void setPipe(String pipe) {
        this.pipe = pipe;
    }

    public int getPipeletId() {
        return pipeletId;
    }

    public void setPipeletId(int pipeletId) {
        this.pipeletId = pipeletId;
    }

    public String getCluster() {
        return cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPwd() {
        return pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public int getMaxCachedTask() {
        return maxCachedTask;
    }

    public void setMaxCachedTask(int maxCachedTask) {
        this.maxCachedTask = maxCachedTask;
    }

    public String getPipeletName() {
        return pipeletName;
    }

    public void setPipeletName(String pipeletName) {
        this.pipeletName = pipeletName;
    }

    public String getQueue() {
        return queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public SessionIdProvider getSessionProvider() {
        return sessionProvider;
    }

    public void setSessionProvider(SessionIdProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    public String getToken4Queue() {
        return token4Queue;
    }

    public void setToken4Queue(String token4Queue) {
        this.token4Queue = token4Queue;
    }

    public int getWindowSize() {
        return windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.windowSize = windowSize;
    }

    /* (non-Javadoc)
             * @see java.lang.Object#clone()
             */
    public BigPipeConf clone() {
    	try {
			return (BigPipeConf) super.clone();
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e.getMessage(), e);
		}
    }
}
