package com.baidu.bigpipe.transport.factory;

import com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter;
import com.baidu.bigpipe.position.store.SubcribePositionStore;
import com.baidu.bigpipe.transport.sub.AsynchronousSubscriber;
import com.baidu.bigpipe.transport.sub.AsynchronousSubscriberBioImpl;

/**
 * 缺省AsynchronousSubscriberFactory实现。
 * 
 * 
 * @author hexiufeng
 *
 */
public class DefaultAsynchronousSubscriberFactory implements AsynchronousSubscriberFactory {
    @Override
    public AsynchronousSubscriber factory(MessageBodyConverter bodyConverter, SubcribePositionStore positionStore) {
        AsynchronousSubscriberBioImpl sub = new AsynchronousSubscriberBioImpl();
        sub.setBodyConverter(bodyConverter);
        sub.setPositionStore(positionStore);
        return sub;
    }

}
