/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.bigpipe.transport.factory.queue;

import com.baidu.bigpipe.transport.queue.AsynchronousQueueSubscriber;

/**
 * 构造AsynchronousSubscriber的工厂抽象
 *
 * @author hexiufeng
 */
public interface AsynchronousQueueSubscriberFactory {
    /**
     * 基于参数构造AsynchronousSubscriber不合理.
     * 工厂的目的是屏蔽实例化细节，
     * 所以MessageBodyConverter bodyConverter, SubcribePositionStore 应该是factory的属性，
     * 构建工厂 只需要getBean()就可以快带创建了才比较合理
     *
     * @return AsynchronousSubscriber
     */
    AsynchronousQueueSubscriber factory();
}
