/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.bigpipe.transport.factory.queue;

import com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter;
import com.baidu.bigpipe.transport.conf.BigPipeConf;
import com.baidu.bigpipe.transport.queue.AsynchronousQueueSubscriber;
import com.baidu.bigpipe.transport.queue.AsynchronousQueueSubscriberBioImpl;
import com.baidu.bigpipe.transport.sub.PipeletIdAwareBigpipeMessageListener;

/**
 * 缺省AsynchronousSubscriberFactory实现。
 *
 * @author hexiufeng
 */
public class DefaultAsynchronousQueueSubscriberFactory implements AsynchronousQueueSubscriberFactory {

    private MessageBodyConverter bodyConverter;

    private BigPipeConf bigPipeConf;

    private PipeletIdAwareBigpipeMessageListener messageListener;

    public DefaultAsynchronousQueueSubscriberFactory(BigPipeConf bigPipeConf, MessageBodyConverter bodyConverter,
                                              PipeletIdAwareBigpipeMessageListener messageListener) {
        this.bigPipeConf = bigPipeConf;
        this.bodyConverter = bodyConverter;
        this.messageListener = messageListener;

    }

    //    private  SubcribePositionStore positionStore; // queue 不需要
    @Override
    public AsynchronousQueueSubscriber factory() {
        AsynchronousQueueSubscriberBioImpl sub = new AsynchronousQueueSubscriberBioImpl();
        sub.setBigPipeConf(bigPipeConf);
        sub.setBodyConverter(bodyConverter);
        sub.setQueueListener(messageListener);
        return sub;
    }

}
