package com.baidu.bigpipe.transport.pub;

import java.util.List;

import com.baidu.bigpipe.exp.PushException;
import com.baidu.bigpipe.protocol.LogIdGen;
import com.baidu.bigpipe.transport.conf.BigPipeConf;

/**
 * 异步发送消息的抽象接口
 * 
 * @author hexiufeng
 * 
 */
public interface AsynchronousPublisher {

    /**
     * 异步发送单个消息，调用方调用该方法立刻返回，不堵塞，但调用{@link com.baidu.bigpipe.transport.pub.SendFutrue#get() SendFutrue的get方法}会堵塞，直到消息被成功
     * 发送或者发送失败
     * 
     * @param message {@link Message} 消息对象
     * @throws PushException PushException
     * @return {@link SendFutrue}对象
     */
    SendFutrue publish(Message message) throws PushException;

    /**
     * 异步发送批量消息，调用方调用该方法立刻返回，不堵塞，但调用{@link com.baidu.bigpipe.transport.pub.SendFutrue#get() SendFutrue的get方法}会堵塞,
     * 直到这一批消息都成功发送或者任意一个发送失败后
     * 
     * @param messageList {@link Message} list
     * @throws PushException PushException
     * @return {@link SendFutrue}对象
     */
    SendFutrue publish(List<Message> messageList) throws PushException;

    /**
     * 初始化publisher
     * 
     * @param conf 配置对象
     */
    void init(BigPipeConf conf);

    /**
     * 关闭publisher
     */
    void shutDown();

    /**
     * 设置publisher内部使用的消息logid生成器
     * 
     * @param idGen {@link LogIdGen} 对象
     */
    void applyMessageIdGen(LogIdGen idGen);
}
