package com.baidu.bigpipe.transport.pub;

/**
 * 消费发送者内部可识别的消息的抽象描述。
 * 
 * @author hexiufeng
 * 
 */
public final class Message {
    /**
     * bigpipe协议支持的log id
     */
    private String logId;
    /**
     * byte[]类型的消息体
     */
    private byte[] body;
    /**
     * 消息发送调用方发送的原始的java消息
     */
    private Object originalMessage;
    /**
     * 消息发送完成或者发送失败触发通知调用方
     */
    InternalFutrue future;
    /**
     * 监控信息
     */
    long pubTime;
    long writeTime;
    boolean packedMessage = false;

    // public Message(){}

    public boolean isPackedMessage() {
        return packedMessage;
    }

    public void setPackedMessage(boolean packedMessage) {
        this.packedMessage = packedMessage;
    }

    public Message(String logId, byte[] body, Object originalMessage) {
        this.logId = logId;
        this.body = body;
        this.originalMessage = originalMessage;
    }

    public String getLogId() {
        return logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }

    public byte[] getBody() {
        return body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Object getOriginalMessage() {
        return originalMessage;
    }

    public void setOriginalMessage(Object originalMessage) {
        this.originalMessage = originalMessage;
    }
}
