package com.baidu.bigpipe.transport.pub;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/**
 * 调用方异步发送消息时所持有的发送结果占位符实现，它实现如下接口：
 * <ul>
 * <li>{@link com.baidu.bigpipe.transport.pub.SendFutrue SendFutrue} 被调用方使用</li>
 * <li>{@link com.baidu.bigpipe.transport.pub.InternalFutrue InternalFutrue} 被内部发送线程使用</li>
 * </ul>
 * 
 * @author hexiufeng
 * 
 */
class SendFutrueImpl implements InternalFutrue, SendFutrue {
    private final CountDownLatch internalWaiter = new CountDownLatch(1);
    /**
     * 失败的消息列表
     */
    private volatile List<Object> failed = Collections.emptyList();
    /**
     * 出错信息
     */
    private volatile String errText;
    /**
     * 当前session Id
     */
    private volatile String sessionId;

    @Override
    public List<Object> get() throws InterruptedException {
        internalWaiter.await();
        return failed;
    }

    @Override
    public void trigger(List<Message> failedList, String errText, String sessionId) {
        this.errText = errText;
        this.sessionId = sessionId;

        if (failedList != null && failedList.size() > 0) {
            List<Object> list = new ArrayList<Object>(failedList.size());
            for (Message m : failedList) {
                list.add(m.getOriginalMessage());
            }
            failed = list;
        }
        internalWaiter.countDown();

    }

    @Override
    public List<Object> get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (internalWaiter.await(timeout, unit)) {
            return failed;
        } else {
            throw new TimeoutException();
        }
    }

    @Override
    public String getError() {
        return errText;
    }

    @Override
    public String getSessionId() {
        return sessionId;
    }

}
