package com.baidu.bigpipe.transport.pub.context;

import java.nio.ByteBuffer;

/**
 * 包内使用，描述一个发送任务,它是一个发送单元，一个发送任务可能包括单个、一批或者一包消息,所有的消息会被 序列化为一个byte[]
 * 
 * @author hexiufeng
 * 
 */
public final class WriteTask {
    /**
     * 需要发送的消息的序列化数组
     */
    private ByteBuffer buf;
    /**
     * 一次发送的识别id，该id能被返回结果带回
     */
    private String logId;
    /**
     * 该发送任务被发送的次数
     */
    private int count = 0;
    /**
     * 如果发送失败,是否需要在Session内部重新发送
     */
    private boolean reConnectAndNoSend = false;
    /**
     * message Id,bigpipe用来保证不重不丢
     */
    private long sessionMessageId;
    
    public ByteBuffer getBuf() {
        return buf;
    }
    public void setBuf(ByteBuffer buf) {
        this.buf = buf;
    }
    public String getLogId() {
        return logId;
    }
    public void setLogId(String logId) {
        this.logId = logId;
    }
    public int getCount() {
        return count;
    }
    public void setCount(int count) {
        this.count = count;
    }
    public boolean isReConnectAndNoSend() {
        return reConnectAndNoSend;
    }
    public void setReConnectAndNoSend(boolean reConnectAndNoSend) {
        this.reConnectAndNoSend = reConnectAndNoSend;
    }
    public long getSessionMessageId() {
        return sessionMessageId;
    }
    public void setSessionMessageId(long sessionMessageId) {
        this.sessionMessageId = sessionMessageId;
    }
}
