package com.baidu.bigpipe.transport.queue;

import com.baidu.bigpipe.transport.sub.PipeletIdAwareBigpipeMessageListener;

/**
 * 异步订阅消息的抽象接口。从bigpipe
 * 订阅消息，接收到消息后自动调用{@link PipeletIdAwareBigpipeMessageListener QueueListener}
 * 进行消息消费，类似于spring activemq的MessageListener Container。一般建议在spirng的init-method中调用startSubscribe，
 * destroy-method中配置shutDown
 *
 * @author liangxiaojie
 */
public interface AsynchronousQueueSubscriber {
    /**
     * 开启以线程，发送订阅指令后，自动接收消息，并调用{@link PipeletIdAwareBigpipeMessageListener QueueListener}
     * 进行消费
     *
     */
    void startSubscribe();

    /**
     * 关闭订阅
     */
    void shutDown();
}
