package com.baidu.bigpipe.transport.sub;

import com.baidu.bigpipe.transport.conf.BigPipeConf;

/**
 * 异步订阅消息的抽象接口。从bigpipe订阅消息，接收到消息后自动调用{@link com.baidu.bigpipe.transport.sub.BigpipeMessageListener BigpipeMessageListener}
 * 进行消息消费，类似于spring activemq的MessageListener Container。一般建议在spirng的init-method中调用startSubscribe，
 * destroy-method中配置shutDown
 * 
 * @author hexiufeng
 *
 */
public interface AsynchronousSubscriber {
    /**
     * 开启以线程，发送订阅指令后，自动接收消息，并调用{@link com.baidu.bigpipe.transport.sub.BigpipeMessageListener BigpipeMessageListener}
     * 进行消费
     * @param listener
     * @param conf
     */
	void startSubscribe(BigpipeMessageListener listener,BigPipeConf conf);
	/**
	 * 关闭订阅
	 */
	void shutDown();
}
