package com.baidu.bigpipe.transport.sub;

import java.util.List;

/**
 * bigpipe消息接收后的后续处理消费抽象
 * 
 * @author hexiufeng
 * 
 */
public interface BigpipeMessageListener {
    /**
     * 消费接收到一组消息，当发送端使用c-api打包协议发送时，订阅接收后会自动解包，因此是一组消息. 注意<br>
     * <ul>
     * <li>成功消费完成消息后,需要记录同步点</li>
     * <li>抛出异常，订阅实现内部会重新订阅该数据.</li>
     * </ul>
     * 
     * @param messageList 消息列表
     * @param messageId messageId
     */
    void handle(List<Object> messageList, long messageId);
}
