/*
 * Copyright (C) 2016 Baidu, Inc. All Rights Reserved.
 */
package com.baidu.bigpipe.transport.sub;

import java.util.List;

/**
 * bigpipe消息接收queu消息后的后续处理消费抽象
 *
 * @author liangxiaojie
 */
public interface PipeletIdAwareBigpipeMessageListener {
    /**
     * 消费接收到一组消息，当发送端使用c-api打包协议发送时，订阅接收后会自动解包，因此是一组消息. 注意<br>
     * <ul>
     * <li>成功消费完成消息后,需要记录同步点</li>
     * <li>抛出异常，订阅实现内部会重新订阅该数据.</li>
     * </ul>
     *
     * @param messageList 消息
     * @param pipeletId 一个queue对应多个pipelet,这个指明了消息从哪个pipelet_id过来
     * @param pipeletMsgId 消息存储在pipelet的位置
     */
    void handle(List<Object> messageList, int pipeletId, long pipeletMsgId);
}
