/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.driver;

import com.baidu.bigpipe.driver.converter.pub.JsonMessageConverter;
import com.baidu.bigpipe.driver.converter.pub.MessageConverter;
import com.baidu.bigpipe.driver.converter.pub.StringMessageConverter;
import com.baidu.bigpipe.protocol.BigpipePackBuilder;
import com.baidu.bigpipe.protocol.DefaultBigpipePackBuilder;
import com.baidu.bigpipe.protocol.LogIdGen;
import com.baidu.bigpipe.protocol.SequenceLogIdGen;
import com.baidu.bigpipe.transport.conf.BigPipeConf;
import com.baidu.bigpipe.transport.conf.SocketConf;
import com.baidu.bigpipe.transport.pub.AsynchronousPublisher;
import com.baidu.bigpipe.transport.pub.AsynchronousPublisherImpl;
import com.baidu.bigpipe.transport.pub.PublishStrategy;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractBigpipeClient {
    protected MessageConverter converter = new JsonMessageConverter();
    protected MessageConverter stringConverter = new StringMessageConverter();
    protected PublishStrategy pubStrategy;
    protected LogIdGen logIdGen = new SequenceLogIdGen();
    protected AsynchronousPublisher publisher;
    protected BigPipeConf conf;
    protected SocketConf socketConf = new SocketConf();
    private static final AtomicBoolean intialized = new AtomicBoolean(false);

    public MessageConverter getConverter() {
        return this.converter;
    }

    public void setConverter(MessageConverter converter) {
        this.converter = converter;
    }

    public BigPipeConf getConf() {
        return this.conf;
    }

    public void setConf(BigPipeConf conf) {
        this.conf = conf;
    }

    public LogIdGen getLogIdGen() {
        return this.logIdGen;
    }

    public void setLogIdGen(LogIdGen logIdGen) {
        this.logIdGen = logIdGen;
    }

    public final BigpipePackBuilder newBigpipePackBuilder() {
        return new DefaultBigpipePackBuilder();
    }

    public void init() {
        if (this.conf == null) {
            throw new RuntimeException("you should configure bigpipe info.");
        }
        if (intialized.compareAndSet(false, true)) {
            if (this.publisher == null) {
                AsynchronousPublisherImpl tmp = new AsynchronousPublisherImpl();
                tmp.setPubStrategy(this.createPublishStrategy());
                tmp.setSocketConf(this.socketConf);
                this.publisher = tmp;
            }
        } else {
            throw new RuntimeException("Client already called initialzed, do not call again.");
        }
        this.publisher.applyMessageIdGen(this.logIdGen);
        this.publisher.init(this.conf);
    }

    public void shutDown() {
        if (this.publisher != null) {
            this.publisher.shutDown();
        }
        intialized.compareAndSet(true, false);
    }

    protected abstract PublishStrategy createPublishStrategy();
}

