/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.driver;

import com.baidu.bigpipe.driver.AbstractBigpipeClient;
import com.baidu.bigpipe.driver.NoneBlockingBigpipePubClient;
import com.baidu.bigpipe.driver.converter.pub.MessageConverter;
import com.baidu.bigpipe.driver.converter.pub.MessageConverterHelper;
import com.baidu.bigpipe.exp.PushException;
import com.baidu.bigpipe.protocol.BigpipePackBuilder;
import com.baidu.bigpipe.transport.pub.GroupPublishStrategy;
import com.baidu.bigpipe.transport.pub.Message;
import com.baidu.bigpipe.transport.pub.PublishStrategy;
import com.baidu.bigpipe.transport.pub.SendFutrue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleNoneBlockingPubClient
extends AbstractBigpipeClient
implements NoneBlockingBigpipePubClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleNoneBlockingPubClient.class);

    @Override
    public SendFutrue publish(Object object, MessageConverter messageConverter) throws PushException {
        byte[] message = MessageConverterHelper.convert(object, messageConverter);
        Message msg = this.convert2Message(message, false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Do publish ");
        }
        return this.publisher.publish(msg);
    }

    @Override
    protected PublishStrategy createPublishStrategy() {
        if (this.pubStrategy == null || !(this.pubStrategy instanceof GroupPublishStrategy)) {
            return new GroupPublishStrategy();
        }
        return this.pubStrategy;
    }

    @Override
    public SendFutrue publishPack(BigpipePackBuilder packBuilder) throws PushException {
        if (packBuilder == null) {
            throw new RuntimeException("param 'packBuilder' is null.");
        }
        byte[] message = packBuilder.toByteArray();
        Message msg = this.convert2Message(message, true);
        return this.publisher.publish(msg);
    }

    private Message convert2Message(byte[] buf, boolean packed) {
        long logId = this.logIdGen.genId();
        Message om = new Message(logId + "", buf, buf);
        om.setPackedMessage(packed);
        return om;
    }

    @Override
    public SendFutrue publish(byte[] message) throws PushException {
        Message msg = this.convert2Message(message, false);
        return this.publisher.publish(msg);
    }
}

