/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.position.store;

import com.baidu.bigpipe.position.store.SubcribePositionStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class LocalFileSubcribePositionStore
implements SubcribePositionStore {
    private String rootPath;
    private String fileName;

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void store(long position) {
        FileChannel chl = this.openFile(true);
        try {
            String line = position + "";
            ByteBuffer buf = ByteBuffer.wrap(line.getBytes("utf-8"));
            while (buf.remaining() > 0) {
                chl.write(buf);
            }
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeCloseFile(chl);
        }
    }

    @Override
    public Long loadPosition() {
        FileChannel chl = this.openFile(false);
        if (chl == null) {
            return null;
        }
        try {
            ByteBuffer buf = ByteBuffer.allocate(128);
            int size = chl.read(buf);
            if (size == 0) {
                Long l = null;
                return l;
            }
            String line = new String(buf.array(), 0, size, "utf-8");
            Long l = Long.parseLong(line);
            return l;
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.safeCloseFile(chl);
        }
        return null;
    }

    private FileChannel openFile(boolean isWrite) {
        FileChannel chl;
        block2: {
            File file = new File(this.getFullFile());
            chl = null;
            try {
                chl = !isWrite ? new FileInputStream(file).getChannel() : new FileOutputStream(file).getChannel();
            }
            catch (FileNotFoundException e) {
                if (!isWrite) break block2;
                throw new RuntimeException(e);
            }
        }
        return chl;
    }

    private void safeCloseFile(FileChannel chl) {
        try {
            if (chl != null) {
                chl.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getFullFile() {
        return this.rootPath + "/" + this.fileName;
    }
}

