/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.position.store;

import com.baidu.bigpipe.position.store.SubcribePositionStore;
import com.baidu.driver4j.bdrp.client.BdrpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RedisSubcribePositionStore
implements SubcribePositionStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisSubcribePositionStore.class);
    @Autowired
    private BdrpClient bdrpClient;
    private String key;
    private int expireSeconds;

    public BdrpClient getBdrpClient() {
        return this.bdrpClient;
    }

    public void setBdrpClient(BdrpClient bdrpClient) {
        this.bdrpClient = bdrpClient;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getExpireSeconds() {
        return this.expireSeconds;
    }

    public void setExpireSeconds(int expireSeconds) {
        this.expireSeconds = expireSeconds;
    }

    @Override
    public void store(long position) {
        if (this.key == null || this.key.length() == 0) {
            LOGGER.error("redis key is null");
            throw new NullPointerException("redis key is null");
        }
        this.bdrpClient.set(this.key, String.valueOf(position));
        if (this.expireSeconds > 0) {
            this.bdrpClient.expire(this.key, this.expireSeconds);
        }
    }

    @Override
    public Long loadPosition() {
        try {
            String line = this.bdrpClient.get(this.key);
            return Long.parseLong(line);
        }
        catch (Exception e) {
            LOGGER.warn("loadPosition fail", (Throwable)e);
            return null;
        }
    }
}

