/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.protocol;

import com.baidu.bigpipe.driver.converter.pub.MessageConverter;
import com.baidu.bigpipe.driver.converter.pub.MessageConverterHelper;
import com.baidu.bigpipe.protocol.BigpipePackBuilder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;

public class DefaultBigpipePackBuilder
implements BigpipePackBuilder {
    private static final int INT_SIZE = 4;
    private final List<byte[]> packedList = new LinkedList<byte[]>();
    private static final int BUFF_LIMIT = 2096128;
    private int maxBuffer = 2096128;
    private ByteBuffer bodyBuf;
    private int currentLength = 0;

    public void setMaxBuffer(int maxBuffer) {
        if (maxBuffer > 0) {
            this.maxBuffer = maxBuffer;
        }
    }

    public DefaultBigpipePackBuilder() {
        this.bodyBuf = ByteBuffer.allocate(this.maxBuffer);
        this.bodyBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.bodyBuf.position(4);
    }

    protected DefaultBigpipePackBuilder(int buffSize) {
        this.maxBuffer = buffSize;
        this.bodyBuf = ByteBuffer.allocate(this.maxBuffer);
        this.bodyBuf.order(ByteOrder.LITTLE_ENDIAN);
        this.bodyBuf.position(4);
    }

    private boolean checkRemaing(byte[] buf) {
        return this.bodyBuf.remaining() >= buf.length + 4;
    }

    @Override
    public boolean add(byte[] buf) {
        if (buf == null) {
            throw new RuntimeException("message is null");
        }
        if (this.checkRemaing(buf)) {
            this.bodyBuf.putInt(buf.length);
            this.bodyBuf.put(buf);
            this.packedList.add(buf);
            this.currentLength += buf.length + 4;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        this.bodyBuf.position(4);
        this.bodyBuf.limit(this.maxBuffer);
        this.packedList.clear();
        this.currentLength = 0;
    }

    @Override
    public boolean hasMessages() {
        return this.packedList.isEmpty();
    }

    @Override
    public List<byte[]> getPackedMessage() {
        return this.packedList;
    }

    protected int getCurrentLen() {
        return this.bodyBuf.limit();
    }

    @Override
    public boolean add(Object object, MessageConverter messageConverter) {
        byte[] message = MessageConverterHelper.convert(object, messageConverter);
        return this.add(message);
    }

    @Override
    public byte[] toByteArray() {
        int totalLength = 4 + this.currentLength;
        byte[] pack = new byte[totalLength];
        this.bodyBuf.position(0);
        this.bodyBuf.putInt(this.currentLength);
        System.arraycopy(this.bodyBuf.array(), 0, pack, 0, totalLength);
        return pack;
    }
}

