/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.protocol;

import com.baidu.bigpipe.protocol.Nshead;
import com.baidu.gson.Gson;
import com.baidu.mcpack.Mcpack;
import com.baidu.mcpack.McpackException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.zip.Adler32;

public class McpackCommand {
    public static final int NSHEAD_MAGICNUM = -76508268;
    public static String encoding = Charset.defaultCharset().name();
    public static final int REQ_QUEUE_DATA = 1;
    public static final int ACK_QUEUE_TRUE_DATA = 2;
    public static final int ACK_QUEUE_FAKE_DATA = 3;

    public static <T> T bufferToProtocol(ByteBuffer buffer, Class<T> classOfT) throws McpackException {
        Gson gson = new Gson();
        Mcpack pack = new Mcpack();
        return (T)gson.fromJson(pack.toJsonElement(encoding, buffer.array()), classOfT);
    }

    public static ByteBuffer protocolToBuffer(McpackCommand cmd) throws McpackException {
        Gson gson = new Gson();
        Mcpack pack = new Mcpack();
        byte[] bytes = pack.toMcpack(encoding, gson.toJsonTree((Object)cmd));
        int bodylen = bytes.length;
        ByteBuffer buffer = ByteBuffer.allocate(36 + bodylen);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(36);
        buffer.put(bytes);
        Adler32 checksum = new Adler32();
        checksum.update(buffer.array(), 36, bodylen);
        Nshead head = new Nshead("QueueClient");
        head.setMagicNumber(-76508268);
        head.setBodyLength(bodylen);
        head.setReserved((int)(checksum.getValue() & 0xFFFFFFFFFFFFFFFFL));
        buffer.position(0);
        head.fillBuffer(buffer);
        buffer.position(0);
        return buffer;
    }
}

