/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.protocol.meta;

import com.baidu.bigpipe.common.support.JsonUtils;
import com.baidu.bigpipe.protocol.meta.DefaultPipeletInstanceRoleStrategy;
import com.baidu.bigpipe.protocol.meta.MetaLoader;
import com.baidu.bigpipe.protocol.meta.PipeletInstanceRoleSelectStrategy;
import com.baidu.bigpipe.protocol.meta.concept.Broker;
import com.baidu.bigpipe.protocol.meta.concept.BrokerGroup;
import com.baidu.bigpipe.protocol.meta.concept.Pipelet;
import com.baidu.bigpipe.protocol.meta.concept.QueueAddress;
import com.baidu.bigpipe.protocol.meta.concept.Stripe;
import com.baidu.bigpipe.protocol.meta.concept.TopicAddress;
import com.baidu.bigpipe.protocol.meta.exp.InvalidParameter;
import com.baidu.bigpipe.protocol.meta.exp.NameResolveException;
import com.baidu.bigpipe.protocol.meta.exp.NameServiceUnkownException;
import com.baidu.bigpipe.protocol.meta.exp.QueueLocateException;
import com.baidu.bigpipe.protocol.meta.exp.StripeOffsetException;
import java.net.InetSocketAddress;
import org.apache.zookeeper.KeeperException;

public final class NameService {
    private PipeletInstanceRoleSelectStrategy roleStrategy = new DefaultPipeletInstanceRoleStrategy();
    private MetaLoader metaLoader;
    private String clusterName;

    public MetaLoader getMetaLoader() {
        return this.metaLoader;
    }

    public void setMetaLoader(MetaLoader metaLoader) {
        this.metaLoader = metaLoader;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public NameService(String topDomainName) {
        this.clusterName = topDomainName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public PipeletInstanceRoleSelectStrategy getRoleStrategy() {
        return this.roleStrategy;
    }

    public void setRoleStrategy(PipeletInstanceRoleSelectStrategy roleStrategy) {
        this.roleStrategy = roleStrategy;
    }

    public TopicAddress lookupForSub(String pipelet, long position) throws NameResolveException, KeeperException {
        return this.lookup(pipelet, position, this.roleStrategy.getCurrentRole());
    }

    public TopicAddress lookupForPub(String pipelet) throws NameResolveException, KeeperException {
        return this.lookup(pipelet, Long.MAX_VALUE, 1);
    }

    private Stripe findStripe(String pipelet, long position) throws NameResolveException, KeeperException {
        String pipeletPath = "/" + this.clusterName + "/meta/pipelet/" + pipelet;
        String pipeletinfo = this.metaLoader.getMeta(pipeletPath);
        Pipelet p = (Pipelet)JsonUtils.json2Object(pipeletinfo, Pipelet.class);
        if (p.getStripes() != null && p.getStripes().size() > 0) {
            long minBeginPos = Long.MAX_VALUE;
            Stripe oldestStripe = null;
            for (Stripe s : p.getStripes()) {
                if (s.getBeginPos() <= 0L || s.getBeginPos() > s.getEndPos()) continue;
                if (s.getBeginPos() < minBeginPos) {
                    minBeginPos = s.getBeginPos();
                    oldestStripe = s;
                }
                if (s.getBeginPos() > position || s.getEndPos() < position) continue;
                return s;
            }
            if (position == 0L) {
                return oldestStripe;
            }
            throw new StripeOffsetException(pipelet, position, oldestStripe.getBeginPos());
        }
        throw new NameResolveException(pipelet, position, "stripe for offset " + position + " failed: no stripe exists");
    }

    private BrokerGroup getGroup(Stripe s) throws KeeperException {
        String groupPath = String.format("/%s/meta/broker_group/%s", this.clusterName, s.getServingGroup());
        String groupInfo = this.metaLoader.getMeta(groupPath);
        return (BrokerGroup)JsonUtils.json2Object(groupInfo, BrokerGroup.class);
    }

    private TopicAddress lookup(String pipelet, long position, int role) throws NameResolveException, KeeperException {
        BrokerGroup group;
        Stripe stripe;
        try {
            stripe = this.findStripe(pipelet, position);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE || e.code() == KeeperException.Code.NOAUTH) {
                throw new InvalidParameter("no access to path " + e.getPath(), (Exception)((Object)e));
            }
            throw e;
        }
        try {
            group = this.getGroup(stripe);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE || e.code() == KeeperException.Code.NOAUTH) {
                throw new NameServiceUnkownException("zookeeper information inconsistency! no access to " + e.getPath(), (Exception)((Object)e));
            }
            throw e;
        }
        TopicAddress addr = new TopicAddress();
        addr.setStripe(stripe);
        if (group.getBrokers() != null && group.getBrokers().size() > 0) {
            for (Broker broker : group.getBrokers()) {
                if (broker.getRole() != role) continue;
                addr.setAddress(new InetSocketAddress(broker.getIp(), broker.getPort()));
                return addr;
            }
        }
        throw new NameServiceUnkownException("zookeeper information inconsistency! group " + stripe.getServingGroup() + " information is abnormal");
    }

    public QueueAddress lookupQueue(String queueName) throws QueueLocateException, KeeperException {
        String queueAddr = "";
        try {
            String queuePath = String.format("/%s/meta/queue/%s", this.clusterName, queueName);
            if (this.metaLoader.stat(queuePath) == null) {
                throw new InvalidParameter("queue " + queueName + " not exist in " + "cluster " + this.clusterName);
            }
            String queueNamePath = String.format("/%s/_register/%s", this.clusterName, queueName);
            byte[] bytes = this.metaLoader.get(queueNamePath);
            queueAddr = new String(bytes).replaceAll("\u0000", "");
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NONODE || e.code() == KeeperException.Code.NOAUTH) {
                QueueLocateException ex = new QueueLocateException(queueName, "can't location queue, may be dead or not started", (Exception)((Object)e));
                throw ex;
            }
        }
        catch (InterruptedException e) {
            QueueLocateException ex = new QueueLocateException(queueName, "reading zookeeper interrupted", e);
            throw ex;
        }
        String[] parts = queueAddr.split(":");
        try {
            InetSocketAddress intAddress = new InetSocketAddress(parts[0], Integer.parseInt(parts[1]));
            QueueAddress addr = new QueueAddress();
            addr.setAddress(intAddress);
            addr.setQueueName(queueName);
            return addr;
        }
        catch (Exception e) {
            QueueLocateException ex = new QueueLocateException(queueName, "process queue address failed", e);
            throw ex;
        }
    }
}

