/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.protocol.meta;

import com.baidu.bigpipe.protocol.meta.MetaLoader;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetaLoader
implements MetaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZKMetaLoader.class);
    private String connectString;

    public String getConnectString() {
        return this.connectString;
    }

    public void setConnectString(String connectString) {
        this.connectString = connectString;
    }

    private ZooKeeper init() {
        ZooKeeper newZk = null;
        try {
            newZk = this.buildZookeeper();
        }
        catch (IOException e) {
            LOGGER.error("init zookeeper error", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            LOGGER.error("init zookeeper error, ", (Throwable)e);
            throw new RuntimeException(e);
        }
        return newZk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String getMeta(String path) throws KeeperException {
        ZooKeeper zk = this.init();
        Stat stat = new Stat();
        byte[] meta = null;
        try {
            meta = zk.getData(path, false, stat);
        }
        catch (InterruptedException e) {
        }
        finally {
            this.safeClose(zk);
        }
        return new String(meta, 8, meta.length - 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Stat stat(String path) throws KeeperException, InterruptedException {
        ZooKeeper zk = this.init();
        Stat stat = null;
        try {
            stat = zk.exists(path, false);
        }
        catch (InterruptedException e) {
        }
        finally {
            this.safeClose(zk);
        }
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized byte[] get(String path) throws KeeperException {
        ZooKeeper zk = this.init();
        Stat stat = new Stat();
        byte[] meta = null;
        try {
            meta = zk.getData(path, false, stat);
        }
        catch (InterruptedException e) {
        }
        finally {
            this.safeClose(zk);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void safeClose(ZooKeeper zk) {
        if (zk == null) {
            return;
        }
        try {
            zk.close();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            zk = null;
        }
    }

    private ZooKeeper buildZookeeper() throws IOException, InterruptedException {
        final CountDownLatch connectLatch = new CountDownLatch(1);
        LOGGER.info("build zookeeper client.");
        ZooKeeper newZk = new ZooKeeper(this.connectString, 5000, new Watcher(){

            public void process(WatchedEvent event) {
                if (Watcher.Event.KeeperState.SyncConnected == event.getState()) {
                    connectLatch.countDown();
                    return;
                }
            }
        });
        connectLatch.await();
        return newZk;
    }
}

