/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.spring;

import com.baidu.bigpipe.spring.PlaceholderResolved;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.util.StringUtils;

public class PlaceholderResolver {
    private static final Logger LOGGER = Logger.getLogger(PlaceholderResolver.class.getName());
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private PlaceholderResolved resolvedInterceptor;
    private Set<String> visitedPlaceholders = new HashSet<String>(50);

    public PlaceholderResolver(PlaceholderResolved resolvedInterceptor) {
        if (resolvedInterceptor == null) {
            throw new IllegalArgumentException("property 'resolvedInterceptor' is null");
        }
        this.resolvedInterceptor = resolvedInterceptor;
    }

    public String doParse(String strVal) {
        if (strVal == null) {
            return strVal;
        }
        return this.parseStringValue(strVal, this.visitedPlaceholders);
    }

    public boolean hasPlaceHolder(String strVal) {
        if (StringUtils.isEmpty((Object)strVal)) {
            return false;
        }
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        return startIndex != -1;
    }

    protected String parseStringValue(String strVal, Set<String> visitedPlaceholders) {
        StringBuilder buf = new StringBuilder(strVal);
        int startIndex = strVal.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(buf, startIndex);
            if (endIndex != -1) {
                String placeholder = buf.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                if (!visitedPlaceholders.add(placeholder)) {
                    throw new RuntimeException("Circular placeholder reference '" + placeholder + "' in property definitions");
                }
                String propVal = this.resolvedInterceptor.doResolved(placeholder = this.parseStringValue(placeholder, visitedPlaceholders));
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, visitedPlaceholders);
                    buf.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    LOGGER.log(Level.FINEST, "Resolved placeholder '" + placeholder + "'");
                    startIndex = buf.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else {
                    startIndex = buf.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                }
                visitedPlaceholders.remove(placeholder);
                continue;
            }
            startIndex = -1;
        }
        return buf.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (PlaceholderResolver.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (PlaceholderResolver.substringMatch(buf, index, this.placeholderPrefix)) {
                ++withinNestedPlaceholder;
                index += this.placeholderPrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        for (int j = 0; j < substring.length(); ++j) {
            int i = index + j;
            if (i < str.length() && str.charAt(i) == substring.charAt(j)) continue;
            return false;
        }
        return true;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }
}

