/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.spring;

import com.baidu.bigpipe.spring.PlaceholderResolved;
import com.baidu.bigpipe.spring.PlaceholderResolver;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.util.ReflectionUtils;

public final class PropertyPlaceholderConfigurerTool {
    public static Properties getRegisteredPropertyResourceConfigurer(ConfigurableListableBeanFactory beanFactory) {
        Method m;
        Class<PropertyPlaceholderConfigurer> clazz = PropertyPlaceholderConfigurer.class;
        Map beans = beanFactory.getBeansOfType(clazz);
        if (beans == null || beans.isEmpty()) {
            return null;
        }
        Object config = beans.entrySet().iterator().next().getValue();
        if (clazz.isAssignableFrom(config.getClass()) && (m = ReflectionUtils.findMethod(clazz, (String)"mergeProperties")) != null) {
            m.setAccessible(true);
            return (Properties)ReflectionUtils.invokeMethod((Method)m, config);
        }
        return null;
    }

    public static PlaceholderResolver createPlaceholderParser(final Properties propertyResource) {
        if (propertyResource == null) {
            return null;
        }
        PlaceholderResolver resolver = new PlaceholderResolver(new PlaceholderResolved(){

            @Override
            public String doResolved(String placeholder) {
                return propertyResource.getProperty(placeholder);
            }
        });
        return resolver;
    }
}

