/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.spring.annotation;

import com.baidu.bigpipe.spring.PlaceholderResolver;
import com.baidu.bigpipe.spring.PropertyPlaceholderConfigurerTool;
import com.baidu.bigpipe.spring.annotation.AnnotationParserCallback;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.PriorityOrdered;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class CommonAnnotationBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware,
DisposableBean,
InitializingBean,
ApplicationListener<ApplicationEvent> {
    protected static final Log LOGGER = LogFactory.getLog(AutowiredAnnotationBeanPostProcessor.class);
    private AnnotationParserCallback callback;
    private int order = 0x7FFFFFFC;
    private ConfigurableListableBeanFactory beanFactory;
    private final Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();
    private Properties propertyResource;
    private PlaceholderResolver resolver;
    private Vector<BeanInfo> typeAnnotationedBeans = new Vector();
    private AtomicBoolean started = new AtomicBoolean(false);

    private AnnotationParserCallback getCallback() {
        return this.callback;
    }

    public void setCallback(AnnotationParserCallback callback) {
        this.callback = callback;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("CommonAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<? extends Annotation> annotation;
        if (this.getCallback() == null) {
            return super.postProcessBeforeInitialization(bean, beanName);
        }
        Class<?> clazz = bean.getClass();
        List<Class<? extends Annotation>> annotations = this.getCallback().getTypeAnnotation();
        if (annotations.isEmpty()) {
            return bean;
        }
        Annotation a = null;
        Iterator<Class<? extends Annotation>> i$ = annotations.iterator();
        while (i$.hasNext() && (a = clazz.getAnnotation(annotation = i$.next())) == null) {
        }
        if (a == null) {
            return bean;
        }
        BeanInfo beanInfo = new BeanInfo(beanName, a);
        this.typeAnnotationedBeans.add(beanInfo);
        return this.getCallback().annotationAtType(a, bean, beanName, this.beanFactory);
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        List<Class<? extends Annotation>> annotations = this.getCallback().getMethodFieldAnnotation();
        if (beanType != null && this.getCallback() != null && annotations != null) {
            InjectionMetadata metadata = this.findAnnotationMetadata(beanType, annotations);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        List<Class<? extends Annotation>> annotations = this.getCallback().getMethodFieldAnnotation();
        if (this.getCallback() == null || annotations == null) {
            return pvs;
        }
        InjectionMetadata metadata = this.findAnnotationMetadata(bean.getClass(), annotations);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Autowiring of methods failed", ex);
        }
        return pvs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findAnnotationMetadata(Class clazz, List<Class<? extends Annotation>> annotion) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    LinkedList<InjectionMetadata.InjectedElement> elements = new LinkedList<InjectionMetadata.InjectedElement>();
                    this.parseFields(clazz, annotion, elements);
                    this.parseMethods(clazz, annotion, elements);
                    metadata = new InjectionMetadata(clazz, elements);
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    protected void parseMethods(final Class<?> clazz, final List<Class<? extends Annotation>> annotions, final LinkedList<InjectionMetadata.InjectedElement> elements) {
        ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) {
                for (Class anno : annotions) {
                    Object annotation = method.getAnnotation(anno);
                    if (annotation == null || !method.equals(ClassUtils.getMostSpecificMethod((Method)method, (Class)clazz))) continue;
                    if (Modifier.isStatic(method.getModifiers())) {
                        throw new IllegalStateException("Autowired annotation is not supported on static methods");
                    }
                    if (method.getParameterTypes().length == 0) {
                        throw new IllegalStateException("Autowired annotation requires at least one argument: " + method);
                    }
                    PropertyDescriptor pd = BeanUtils.findPropertyForMethod((Method)method);
                    elements.add(new AutowiredMethodElement(method, (Annotation)annotation, pd));
                }
            }
        });
    }

    protected void parseFields(Class<?> clazz, final List<Class<? extends Annotation>> annotions, final LinkedList<InjectionMetadata.InjectedElement> elements) {
        ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                for (Class anno : annotions) {
                    Object annotation = field.getAnnotation(anno);
                    if (annotation == null) continue;
                    if (Modifier.isStatic(field.getModifiers())) {
                        throw new IllegalStateException("Autowired annotation is not supported on static fields");
                    }
                    elements.add(new AutowiredFieldElement(field, (Annotation)annotation));
                }
            }
        });
    }

    public void destroy() throws Exception {
        if (this.getCallback() != null) {
            this.getCallback().destroy();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getCallback(), (String)"property 'callbck' must be set");
        this.propertyResource = PropertyPlaceholderConfigurerTool.getRegisteredPropertyResourceConfigurer(this.beanFactory);
        if (this.resolver == null) {
            this.resolver = PropertyPlaceholderConfigurerTool.createPlaceholderParser(this.propertyResource);
        }
        if (this.getCallback() != null) {
            this.getCallback().setPlaceholderResolver(this.resolver);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStartedEvent || event instanceof ContextRefreshedEvent) {
            if (this.started.compareAndSet(false, true)) {
                for (BeanInfo bean : this.typeAnnotationedBeans) {
                    if (this.getCallback() == null) continue;
                    Object targetBean = this.beanFactory.getBean(bean.name);
                    this.getCallback().annotationAtTypeAfterStarted(bean.annotation, targetBean, bean.name, this.beanFactory);
                }
            } else {
                LOGGER.warn((Object)("onApplicationEvent of application event [" + event + "] ignored due to processor already started."));
            }
        }
    }

    private static class BeanInfo {
        private String name;
        private Annotation annotation;

        public BeanInfo(String name, Annotation annotation) {
            this.name = name;
            this.annotation = annotation;
        }
    }

    private class AutowiredMethodElement
    extends InjectionMetadata.InjectedElement {
        private final Annotation annotation;

        public AutowiredMethodElement(Method method, Annotation annotation, PropertyDescriptor pd) {
            super((Member)method, pd);
            this.annotation = annotation;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            if (this.skip == null && this.pd != null && pvs != null && pvs.contains(this.pd.getName())) {
                this.skip = Boolean.TRUE;
            }
            if (this.skip != null && this.skip.booleanValue()) {
                return;
            }
            Method method = (Method)this.member;
            try {
                Object[] arguments = null;
                Class<?>[] paramTypes = method.getParameterTypes();
                arguments = new Object[paramTypes.length];
                for (int i = 0; i < arguments.length; ++i) {
                    MethodParameter methodParam = new MethodParameter(method, i);
                    GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, bean.getClass());
                    arguments[i] = CommonAnnotationBeanPostProcessor.this.getCallback().annotationAtMethod(this.annotation, bean, beanName, pvs, CommonAnnotationBeanPostProcessor.this.beanFactory, method);
                    if (arguments[i] != null) continue;
                    arguments = null;
                    break;
                }
                if (this.skip == null) {
                    if (this.pd != null && pvs instanceof MutablePropertyValues) {
                        ((MutablePropertyValues)pvs).registerProcessedProperty(this.pd.getName());
                    }
                    this.skip = Boolean.FALSE;
                }
                if (arguments != null) {
                    ReflectionUtils.makeAccessible((Method)method);
                    method.invoke(bean, arguments);
                }
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Could not autowire method: " + method, ex);
            }
        }
    }

    private class AutowiredFieldElement
    extends InjectionMetadata.InjectedElement {
        private final Annotation annotation;

        public AutowiredFieldElement(Field field, Annotation annotation) {
            super((Member)field, null);
            this.annotation = annotation;
        }

        protected void inject(Object bean, String beanName, PropertyValues pvs) throws Throwable {
            Field field = (Field)this.member;
            try {
                ReflectionUtils.makeAccessible((Field)field);
                Object value = field.get(bean);
                value = CommonAnnotationBeanPostProcessor.this.getCallback().annotationAtField(this.annotation, value, beanName, pvs, CommonAnnotationBeanPostProcessor.this.beanFactory, field);
                if (value != null) {
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(bean, value);
                }
            }
            catch (Throwable ex) {
                throw new BeanCreationException("Could not autowire field: " + field, ex);
            }
        }
    }
}

