/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.spring.annotation;

import com.baidu.bigpipe.driver.DefaultListenerSubscriber;
import com.baidu.bigpipe.driver.DefaultQueueListenerSubscriber;
import com.baidu.bigpipe.driver.ListenerSubscriber;
import com.baidu.bigpipe.driver.QueueListenerSubscriber;
import com.baidu.bigpipe.driver.SimpleNoneBlockingPubClient;
import com.baidu.bigpipe.driver.converter.sub.MessageBodyConverter;
import com.baidu.bigpipe.driver.converter.sub.StringMessageBodyConverter;
import com.baidu.bigpipe.position.store.SubcribePositionStore;
import com.baidu.bigpipe.spring.annotation.AbstractAnnotationParserCallback;
import com.baidu.bigpipe.spring.annotation.MessageListener;
import com.baidu.bigpipe.spring.annotation.MessageSender;
import com.baidu.bigpipe.spring.annotation.QueueMessageListener;
import com.baidu.bigpipe.transport.conf.BigPipeConf;
import com.baidu.bigpipe.transport.sub.BigpipeMessageListener;
import com.baidu.bigpipe.transport.sub.PipeletIdAwareBigpipeMessageListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class MessageListenerAnnotationResolver
extends AbstractAnnotationParserCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageListenerAnnotationResolver.class);
    private List<ListenerSubscriber> listenerSubscribers = new ArrayList<ListenerSubscriber>();
    private List<QueueListenerSubscriber> queueListenerSubscribers = new ArrayList<QueueListenerSubscriber>();
    private List<SimpleNoneBlockingPubClient> clients = new ArrayList<SimpleNoneBlockingPubClient>();

    @Override
    public Object annotationAtType(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (t instanceof MessageListener) {
            if (bean instanceof BigpipeMessageListener) {
                LOGGER.info("Annotation 'MessageListener' for target '" + beanName + "' detected and add to message listener callback.");
                ListenerSubscriber listenerSubscriber = this.doParseListenerSubscriber((MessageListener)t, (BigpipeMessageListener)bean, beanName, beanFactory);
                this.listenerSubscribers.add(listenerSubscriber);
            } else {
                throw new BeanInitializationException("Annotation 'MessageListener' for target '" + beanName + "' is not implments " + BigpipeMessageListener.class.getName());
            }
        }
        if (t instanceof QueueMessageListener) {
            if (bean instanceof PipeletIdAwareBigpipeMessageListener) {
                LOGGER.info("Annotation 'QueueMessageListener' for target '" + beanName + "' detected and add to queue message listener callback.");
                QueueListenerSubscriber queueListenerSubscriber = this.doParseQueueListenerSubscriber((QueueMessageListener)t, (PipeletIdAwareBigpipeMessageListener)bean, beanName, beanFactory);
                this.queueListenerSubscribers.add(queueListenerSubscriber);
            } else {
                throw new BeanInitializationException("Annotation 'MessageListener' for target '" + beanName + "' is not implments " + BigpipeMessageListener.class.getName());
            }
        }
        return bean;
    }

    private ListenerSubscriber doParseListenerSubscriber(MessageListener t, BigpipeMessageListener bean, String beanName, ConfigurableListableBeanFactory beanFactory) {
        MessageBodyConverter<String> messageBodyConverter;
        String bigPipeConfBeanName = this.parsePlaceholder(t.bigPipeConf());
        BigPipeConf bigPipeConf = (BigPipeConf)beanFactory.getBean(bigPipeConfBeanName, BigPipeConf.class);
        BigPipeConf eBigPipeConf = bigPipeConf.clone();
        if (!StringUtils.isEmpty((Object)t.pipeletName())) {
            String pipeLetName = this.parsePlaceholder(t.pipeletName());
            eBigPipeConf.setPipeletName(pipeLetName);
        }
        if (!StringUtils.isEmpty((Object)t.cluster())) {
            String cluster = this.parsePlaceholder(t.cluster());
            eBigPipeConf.setCluster(cluster);
        }
        if (!StringUtils.isEmpty((Object)t.pipeletId())) {
            String pipeletId = this.parsePlaceholder(t.pipeletId());
            eBigPipeConf.setPipeletId((Integer)NumberUtils.parseNumber((String)pipeletId, Integer.TYPE));
        }
        DefaultListenerSubscriber listenerSubscriber = new DefaultListenerSubscriber();
        listenerSubscriber.setConf(eBigPipeConf);
        if (!StringUtils.isEmpty((Object)t.subcribePositionStore())) {
            String name = this.parsePlaceholder(t.subcribePositionStore());
            SubcribePositionStore subcribePositionStore = (SubcribePositionStore)beanFactory.getBean(name, SubcribePositionStore.class);
            listenerSubscriber.setPositionStore(subcribePositionStore);
        }
        if (!StringUtils.isEmpty((Object)t.bodyConverter())) {
            String bodyConverter = this.parsePlaceholder(t.bodyConverter());
            messageBodyConverter = (MessageBodyConverter)beanFactory.getBean(bodyConverter, MessageBodyConverter.class);
        } else {
            messageBodyConverter = new StringMessageBodyConverter();
        }
        listenerSubscriber.setBodyConverter(messageBodyConverter);
        listenerSubscriber.setMessageListener(bean);
        listenerSubscriber.init();
        return listenerSubscriber;
    }

    private QueueListenerSubscriber doParseQueueListenerSubscriber(QueueMessageListener t, PipeletIdAwareBigpipeMessageListener bean, String beanName, ConfigurableListableBeanFactory beanFactory) {
        MessageBodyConverter<String> messageBodyConverter;
        String bigPipeConfBeanName = this.parsePlaceholder(t.bigPipeConf());
        BigPipeConf bigPipeConf = (BigPipeConf)beanFactory.getBean(bigPipeConfBeanName, BigPipeConf.class);
        BigPipeConf eBigPipeConf = bigPipeConf.clone();
        if (!StringUtils.isEmpty((Object)t.pipeletName())) {
            String pipeLetName = this.parsePlaceholder(t.pipeletName());
            eBigPipeConf.setPipeletName(pipeLetName);
        }
        if (!StringUtils.isEmpty((Object)t.cluster())) {
            String cluster = this.parsePlaceholder(t.cluster());
            eBigPipeConf.setCluster(cluster);
        }
        DefaultQueueListenerSubscriber listenerSubscriber = new DefaultQueueListenerSubscriber();
        listenerSubscriber.setConf(eBigPipeConf);
        if (!StringUtils.isEmpty((Object)t.bodyConverter())) {
            String bodyConverter = this.parsePlaceholder(t.bodyConverter());
            messageBodyConverter = (MessageBodyConverter)beanFactory.getBean(bodyConverter, MessageBodyConverter.class);
        } else {
            messageBodyConverter = new StringMessageBodyConverter();
        }
        listenerSubscriber.setBodyConverter(messageBodyConverter);
        listenerSubscriber.setMessageListener(bean);
        listenerSubscriber.init();
        return listenerSubscriber;
    }

    @Override
    public void annotationAtTypeAfterStarted(Annotation t, Object bean, String beanName, ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }

    @Override
    public Object annotationAtField(Annotation t, Object value, String beanName, PropertyValues pvs, ConfigurableListableBeanFactory beanFactory, Field field) throws BeansException {
        if (t instanceof MessageSender) {
            SimpleNoneBlockingPubClient client = this.doParseMessageSenderAnnotation((MessageSender)t, beanFactory);
            this.clients.add(client);
            return client;
        }
        return value;
    }

    private SimpleNoneBlockingPubClient doParseMessageSenderAnnotation(MessageSender t, ConfigurableListableBeanFactory beanFactory) {
        String bigPipeConfBeanName = this.parsePlaceholder(t.bigPipeConf());
        BigPipeConf bigPipeConf = (BigPipeConf)beanFactory.getBean(bigPipeConfBeanName, BigPipeConf.class);
        BigPipeConf eBigPipeConf = bigPipeConf.clone();
        if (!StringUtils.isEmpty((Object)t.pipeletName())) {
            String pipeLetName = this.parsePlaceholder(t.pipeletName());
            eBigPipeConf.setPipeletName(pipeLetName);
        }
        if (!StringUtils.isEmpty((Object)t.cluster())) {
            String cluster = this.parsePlaceholder(t.cluster());
            eBigPipeConf.setCluster(cluster);
        }
        if (!StringUtils.isEmpty((Object)t.pipeletId())) {
            String pipeletId = this.parsePlaceholder(t.pipeletId());
            eBigPipeConf.setPipeletId((Integer)NumberUtils.parseNumber((String)pipeletId, Integer.TYPE));
        }
        SimpleNoneBlockingPubClient client = new SimpleNoneBlockingPubClient();
        client.setConf(eBigPipeConf);
        client.init();
        return client;
    }

    @Override
    public Object annotationAtMethod(Annotation t, Object value, String beanName, PropertyValues pvs, ConfigurableListableBeanFactory beanFactory, Method method) throws BeansException {
        return value;
    }

    @Override
    public List<Class<? extends Annotation>> getTypeAnnotation() {
        ArrayList<Class<? extends Annotation>> annos = new ArrayList<Class<? extends Annotation>>();
        annos.add(MessageListener.class);
        annos.add(QueueMessageListener.class);
        return annos;
    }

    @Override
    public List<Class<? extends Annotation>> getMethodFieldAnnotation() {
        ArrayList<Class<? extends Annotation>> annos = new ArrayList<Class<? extends Annotation>>();
        annos.add(MessageSender.class);
        return annos;
    }

    @Override
    public void destroy() throws Exception {
        for (ListenerSubscriber listenerSubscriber : this.listenerSubscribers) {
            try {
                listenerSubscriber.shutDown();
            }
            catch (Exception e) {
                LOGGER.error("error on shutdown listener subscriber due to :" + e.getMessage(), (Throwable)e);
            }
        }
        for (QueueListenerSubscriber queueListenerSubscriber : this.queueListenerSubscribers) {
            try {
                queueListenerSubscriber.shutDown();
            }
            catch (Exception e) {
                LOGGER.error("error on shutdown listener subscriber due to :" + e.getMessage(), (Throwable)e);
            }
        }
        for (SimpleNoneBlockingPubClient simpleNoneBlockingPubClient : this.clients) {
            try {
                simpleNoneBlockingPubClient.shutDown();
            }
            catch (Exception e) {
                LOGGER.error("error on shutdown sender due to :" + e.getMessage(), (Throwable)e);
            }
        }
    }
}

