/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.transport;

import com.baidu.bigpipe.protocol.BigpipePacket;
import com.baidu.bigpipe.protocol.meta.exp.InvalidParameter;
import com.baidu.bigpipe.protocol.pb.BigpipePBProtocol;
import com.baidu.bigpipe.transport.PipeRuntime;
import com.baidu.bigpipe.transport.PipeletInfo;
import com.baidu.bigpipe.transport.Receiver;
import com.baidu.bigpipe.transport.SessionSocketStream;
import com.baidu.bigpipe.transport.TransportStrategy;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractSessionSocketStream
implements SessionSocketStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSessionSocketStream.class);
    public static final int BIGPIPE_ROLE_PUB = 4;
    public static final int BIGPIPE_ROLE_SUB = 5;

    @Override
    public void connectSession(PipeRuntime pipeRuntime, PipeletInfo pipeletInfo) throws IOException {
        this.connectSession(pipeRuntime, pipeletInfo, this.buildSocketIfNotExist(), this.getTransStrategy(), this.getReceiver(), this.getRole());
    }

    protected abstract Socket buildSocketIfNotExist();

    protected abstract TransportStrategy getTransStrategy();

    protected abstract Receiver getReceiver();

    protected abstract int getRole();

    protected abstract void afterCreateSession() throws IOException;

    private void connectSession(PipeRuntime pipeRuntime, PipeletInfo pipeletInfo, Socket socket, TransportStrategy transStrategy, Receiver reciever, int role) throws IOException {
        if (!StringUtils.isEmpty((Object)pipeRuntime.getQueueName())) {
            this.afterCreateSession();
            return;
        }
        BigpipePBProtocol.BigpipeCommand.Builder cmd = BigpipePBProtocol.BigpipeCommand.newBuilder();
        cmd.setType(BigpipePBProtocol.BigpipeCommand.CommandType.BMQ_CONNECT);
        BigpipePBProtocol.ConnectCommand.Builder connCmd = cmd.getConnectBuilder();
        connCmd.setRole(role);
        String oldSession = pipeRuntime.sessionIdProvider.getSessionId(false);
        connCmd.setSessionId(pipeRuntime.sessionIdProvider.getSessionId(pipeRuntime.refreshSessionId));
        if (pipeletInfo.getUserName() == null || pipeletInfo.getUserName().equals("")) {
            throw new InvalidParameter("username can not empty!");
        }
        connCmd.setTopicName(pipeRuntime.topicName);
        BigpipePBProtocol.AclCommand.Builder aclCmd = connCmd.getAuthorityBuilder();
        aclCmd.setUsername(pipeletInfo.getUserName());
        aclCmd.setPassword(pipeletInfo.getPwd());
        BigpipePBProtocol.BigpipeCommand command = cmd.build();
        ByteBuffer buf = transStrategy.buildSimpleCommand(command.toByteArray());
        socket.getOutputStream().write(buf.array(), 0, buf.limit());
        ByteBuffer read = reciever.blockRecieve(socket);
        if (read == null) {
            throw new RuntimeException("connect session failed");
        }
        BigpipePacket connected = AbstractSessionSocketStream.parseCommand(read);
        if (connected.getCommand().getType() != BigpipePBProtocol.BigpipeCommand.CommandType.BMQ_CONNECTED) {
            throw new RuntimeException(connected.getCommand().getError().toString() + ",[old:cur]--" + oldSession + ":" + connCmd.getSessionId());
        }
        long serverMessageId = connected.getCommand().getConnected().getSessionMessageId();
        LOGGER.warn("server session messageid {},local messageid {}", (Object)serverMessageId, (Object)pipeRuntime.sessionMessageId);
        if (serverMessageId > pipeRuntime.sessionMessageId) {
            pipeRuntime.sessionMessageId = serverMessageId;
        }
        this.afterCreateSession();
    }

    public static BigpipePacket parseCommand(ByteBuffer read) throws InvalidProtocolBufferException {
        read.order(ByteOrder.LITTLE_ENDIAN);
        int length = read.getInt();
        byte[] ackBuf = new byte[length];
        read.get(ackBuf);
        BigpipePBProtocol.BigpipeCommand ack = BigpipePBProtocol.BigpipeCommand.parseFrom(ackBuf);
        BigpipePacket pack = new BigpipePacket();
        pack.setCommand(ack);
        if (read.remaining() > 0) {
            byte[] payload = new byte[read.remaining()];
            read.get(payload);
            pack.setPayload(payload);
        }
        return pack;
    }
}

