/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.transport;

import com.baidu.bigpipe.transport.NSHead;
import com.baidu.bigpipe.transport.TransportStrategy;
import com.baidu.bigpipe.transport.conf.SocketConf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Adler32;

public class NHeadTransportStrategy
implements TransportStrategy {
    protected String provider = "baidu4j-bigpipe";
    protected final Adler32 checksum = new Adler32();
    static final int INT_SIZE = 4;
    protected SocketConf socketConf;

    @Override
    public ByteBuffer buildSimpleCommand(byte[] buf) {
        NSHead head = NSHead.factory(this.provider);
        head.setBodyLen(buf.length + 4);
        byte[] pack = new byte[buf.length + 4 + 36];
        ByteBuffer bbf = ByteBuffer.wrap(pack);
        bbf.order(ByteOrder.LITTLE_ENDIAN);
        bbf.position(36);
        bbf.putInt(buf.length);
        bbf.put(buf);
        this.checksum.update(pack, 36, buf.length + 4);
        head.setReserved((int)(this.checksum.getValue() & 0xFFFFFFFFFFFFFFFFL));
        this.checksum.reset();
        System.arraycopy(head.toBytes(), 0, pack, 0, 36);
        bbf.flip();
        return bbf;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public void applySocketConf(SocketConf conf) {
        this.socketConf = conf;
    }
}

