/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.transport;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public final class NSHead {
    public static final int SIZE = 36;
    private static final int VERSION = 2;
    private static final int PROVIDER_LEN = 16;
    private static final long MAGIC_NUM = 19902010L;
    private static String DEF_ENCODING = "GBK";
    private int id = 0;
    private int version = 0;
    private long logId = 0L;
    private String provider;
    private long magicNum = 19902010L;
    private long reserved;
    private long bodyLen;

    private NSHead() {
    }

    private NSHead(String provider) {
        this(0, 2, 0L, provider, 19902010L, 0, 0L);
    }

    private NSHead(int id, int version, long logId, String provider, long magicNum, int reserved, long bodyLen) {
        this.id = id;
        this.version = version;
        this.logId = logId;
        this.provider = provider;
        this.magicNum = magicNum;
        this.reserved = reserved;
        this.bodyLen = bodyLen;
    }

    public static NSHead factory(String provider) {
        return new NSHead(provider);
    }

    public byte[] toBytes() {
        ByteBuffer bb = ByteBuffer.allocate(36);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        try {
            bb.putShort((short)this.id);
            bb.putShort((short)this.version);
            bb.putInt((int)this.logId);
            byte[] prvd = this.provider.getBytes(DEF_ENCODING);
            byte[] pb = new byte[16];
            System.arraycopy(prvd, 0, pb, 0, prvd.length);
            bb.put(pb);
            bb.putInt((int)this.magicNum);
            bb.putInt((int)this.reserved);
            bb.putInt((int)this.bodyLen);
        }
        catch (Exception e) {
            throw new RuntimeException("exception when putting bytes for nshead...", e);
        }
        return bb.array();
    }

    public static NSHead fromBytes(byte[] headBytes) {
        NSHead head = new NSHead();
        if (headBytes.length < 36) {
            throw new RuntimeException("NSHead's size should equal 16.");
        }
        ByteBuffer buffer = ByteBuffer.wrap(headBytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        head.id = buffer.getShort();
        head.version = buffer.getShort();
        head.logId = buffer.getInt();
        byte[] hb = new byte[16];
        buffer.get(hb, 0, 16);
        try {
            head.setProvider(new String(hb, DEF_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        head.magicNum = buffer.getInt();
        head.reserved = buffer.getInt();
        head.bodyLen = buffer.getInt();
        return head;
    }

    public String toString() {
        return "[ version: " + this.version + ", id:" + this.id + " logId:" + this.logId + " bodyLen:" + this.bodyLen + "]";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public long getLogId() {
        return this.logId;
    }

    public void setLogId(long logId) {
        this.logId = logId;
    }

    public String getProvider(String charset) {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public long getMagicNum() {
        return this.magicNum;
    }

    public void setMagicNum(long magicNum) {
        this.magicNum = magicNum;
    }

    public long getReserved() {
        return this.reserved;
    }

    public void setReserved(int reserved) {
        this.reserved = reserved;
    }

    public long getBodyLen() {
        return this.bodyLen;
    }

    public void setBodyLen(int bodyLen) {
        this.bodyLen = bodyLen;
    }
}

