/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.transport;

import com.baidu.bigpipe.transport.NSHead;
import com.baidu.bigpipe.transport.Receiver;
import com.baidu.bigpipe.transport.pub.context.ReadContext;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class NsHeadReciever
implements Receiver {
    @Override
    public void recieve(SocketChannel channel, ReadContext context) throws IOException {
        int cnt;
        if (context.getBuf() == null && context.isHeader()) {
            context.setBuf(ByteBuffer.allocate(36));
        }
        if (context.isHeader()) {
            cnt = channel.read(context.getBuf());
            if (cnt == -1) {
                context.setEnd(true);
                return;
            }
            if (context.getBuf().remaining() > 0) {
                return;
            }
            NSHead head = NSHead.fromBytes(context.getBuf().array());
            context.setBuf(ByteBuffer.allocate((int)head.getBodyLen()));
            context.setHeader(false);
        }
        if ((cnt = channel.read(context.getBuf())) == -1) {
            context.setEnd(true);
            return;
        }
        if (context.getBuf().remaining() == 0) {
            context.setComplete(true);
        }
    }

    @Override
    public ByteBuffer blockRecieve(Socket socket) throws IOException {
        byte[] head = new byte[36];
        if (!this.blockRead(socket, head)) {
            return null;
        }
        NSHead nh = NSHead.fromBytes(head);
        byte[] buff = new byte[(int)nh.getBodyLen()];
        if (!this.blockRead(socket, buff)) {
            return null;
        }
        return ByteBuffer.wrap(buff);
    }

    private boolean blockRead(Socket socket, byte[] buffer) throws IOException {
        int read;
        for (int remaining = buffer.length; remaining > 0; remaining -= read) {
            read = socket.getInputStream().read(buffer, buffer.length - remaining, remaining);
            if (read != -1) continue;
            return false;
        }
        return true;
    }
}

