/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.transport.pub;

import com.baidu.bigpipe.protocol.SessionIdProvider;
import com.baidu.bigpipe.protocol.pb.BigpipePBProtocol;
import com.baidu.bigpipe.transport.NHeadTransportStrategy;
import com.baidu.bigpipe.transport.pub.PublishStrategy;
import com.google.protobuf.InvalidProtocolBufferException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPublishStrategy
extends NHeadTransportStrategy
implements PublishStrategy {
    private static final Logger MESSAGEID_LOGGER = LoggerFactory.getLogger((String)"bigpipe.topic.messageid.log");
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPublishStrategy.class);
    private int taskLimitCount = 20000;
    private Semaphore taskLimit = new Semaphore(20000);
    private int maxConcurrent = 1;
    private int conCurrent = 0;
    private int acquireTimeout = 5000;

    public int getTaskLimitCount() {
        return this.taskLimitCount;
    }

    public void setTaskLimitCount(int taskLimitCount) {
        this.taskLimitCount = taskLimitCount;
        this.taskLimit = new Semaphore(taskLimitCount);
    }

    public int getMaxConcurrent() {
        return this.maxConcurrent;
    }

    public void setMaxConcurrent(int maxConcurrent) {
        this.maxConcurrent = maxConcurrent;
    }

    @Override
    public void accqireToken() throws InterruptedException {
        if (!this.taskLimit.tryAcquire(this.acquireTimeout, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("wait to pub timeout");
        }
    }

    @Override
    public void accqireToken(int n) throws InterruptedException {
        if (!this.taskLimit.tryAcquire(n, this.acquireTimeout, TimeUnit.MILLISECONDS)) {
            throw new RuntimeException("wait to pub timeout");
        }
    }

    @Override
    public void releaseToken(int n) {
        this.taskLimit.release(n);
    }

    @Override
    public void releaseToken() {
        this.taskLimit.release();
    }

    @Override
    public void finishPub(ByteBuffer buf, SessionIdProvider sessionIdProvider) {
        buf.order(ByteOrder.LITTLE_ENDIAN);
        int length = buf.getInt();
        byte[] ackBuf = new byte[length];
        buf.get(ackBuf);
        String logId = null;
        long status = 0L;
        try {
            BigpipePBProtocol.BigpipeCommand ack = BigpipePBProtocol.BigpipeCommand.parseFrom(ackBuf);
            if (ack.getType() != BigpipePBProtocol.BigpipeCommand.CommandType.BMQ_ACK) {
                LOGGER.error(ack.getError().toString());
                this.fastFailedRunning(sessionIdProvider);
            }
            status = ack.getAck().getStatus();
            logId = ack.getAck().getReceiptId();
            MESSAGEID_LOGGER.debug("published message position: {}", (Object)ack.getAck().getTopicMessageId());
        }
        catch (InvalidProtocolBufferException e) {
            this.fastFailedRunning(sessionIdProvider);
            return;
        }
        this.handleFinish(logId, status, sessionIdProvider);
    }

    protected abstract void fastFailedRunning(SessionIdProvider var1);

    protected abstract void handleFinish(String var1, long var2, SessionIdProvider var4);

    protected boolean canRunTask() {
        return this.conCurrent < this.maxConcurrent;
    }

    protected void registerRunTask() {
        ++this.conCurrent;
    }

    protected void unRegisterRunTask() {
        --this.conCurrent;
    }
}

