/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.bigpipe.transport.pub;

import com.baidu.bigpipe.transport.pub.InternalFutrue;
import com.baidu.bigpipe.transport.pub.Message;
import com.baidu.bigpipe.transport.pub.SendFutrue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class SendFutrueImpl
implements InternalFutrue,
SendFutrue {
    private final CountDownLatch internalWaiter = new CountDownLatch(1);
    private volatile List<Object> failed = Collections.emptyList();
    private volatile String errText;
    private volatile String sessionId;

    SendFutrueImpl() {
    }

    @Override
    public List<Object> get() throws InterruptedException {
        this.internalWaiter.await();
        return this.failed;
    }

    @Override
    public void trigger(List<Message> failedList, String errText, String sessionId) {
        this.errText = errText;
        this.sessionId = sessionId;
        if (failedList != null && failedList.size() > 0) {
            ArrayList<Object> list = new ArrayList<Object>(failedList.size());
            for (Message m : failedList) {
                list.add(m.getOriginalMessage());
            }
            this.failed = list;
        }
        this.internalWaiter.countDown();
    }

    @Override
    public List<Object> get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (this.internalWaiter.await(timeout, unit)) {
            return this.failed;
        }
        throw new TimeoutException();
    }

    @Override
    public String getError() {
        return this.errText;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }
}

