/**
 * 
 */
package com.baidu.driver4j.bns.spring;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

import com.baidu.driver4j.bns.BNSQueryProxy;
import com.baidu.driver4j.bns.StringUtils;

/**
 * Factory bean for {@link BNSQueryProxy} instance.
 * 
 * @author xiemalin
 * @since 1.0.0
 */
public class BNSQueryFactoryBean implements FactoryBean, InitializingBean, DisposableBean {

    /**
     * connectTimeout in ms
     */
    private int connectTimeout;

    /**
     * readTimeout in ms
     */
    private int readTimeout;

    private BNSQueryProxy bnsQueryProxy;
    
    /**
     * serviceUrl BNS service url
     */
    private String serviceUrl;

    /*
     * (non-Javadoc)
     * 
     * @see org.springframework.beans.factory.DisposableBean#destroy()
     */
    public void destroy() throws Exception {

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.isEmpty(serviceUrl)) {
            bnsQueryProxy = BNSQueryProxy.proxy(serviceUrl);
        } else {
            bnsQueryProxy = BNSQueryProxy.proxy();
        }
        bnsQueryProxy.setConnectTimeout(connectTimeout);
        bnsQueryProxy.setReadTimeout(readTimeout);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.springframework.beans.factory.FactoryBean#getObject()
     */
    public Object getObject() throws Exception {
        return bnsQueryProxy;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.springframework.beans.factory.FactoryBean#getObjectType()
     */
    public Class getObjectType() {
        return BNSQueryProxy.class;
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.springframework.beans.factory.FactoryBean#isSingleton()
     */
    public boolean isSingleton() {
        return true;
    }

    /**
     * setter method for property connectTimeout
     * 
     * @param connectTimeout the connectTimeout to set
     */
    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout > 0) {
            this.connectTimeout = connectTimeout;
        }
    }

    /**
     * setter method for property readTimeout
     * 
     * @param readTimeout the readTimeout to set
     */
    public void setReadTimeout(int readTimeout) {
        if (readTimeout > 0) {
            this.readTimeout = readTimeout;
        }
    }
    
    /**
     * setter method for property serviceUrl
     * @param serviceUrl the serviceUrl to set
     */
    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }
}
