/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bns;

import com.baidu.driver4j.bns.BNSException;
import com.baidu.driver4j.bns.BNSHead;
import com.baidu.driver4j.bns.BNSQueryProxy;
import com.baidu.driver4j.bns.Instance;
import com.baidu.driver4j.bns.InstanceQuery;
import com.baidu.driver4j.bns.SelectionStrategy;
import com.baidu.driver4j.bns.Service;
import com.baidu.driver4j.bns.SocketUtils;
import com.baidu.driver4j.bns.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BNSQueryAgentProxy
implements InstanceQuery {
    private static final int QUERY_INSTANCE_STATUS = 0;
    private static final String PORT_NAME_SPLIT = "=";
    private static final String MULTI_PORT_SPLIT = ",";
    private static final String DEFAULT_TOKEN = "00000000";
    private static final String PROC_NET_ROUTE_COMMAND = "/proc/net/route";
    private static final String JPAAS_HOST_NAME = "JPAAS_HOST";
    private static final String LOCAL_IP_STARTS = "192.168";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNSQueryAgentProxy.class.getName());
    private BNSQueryProxy bnsQueryProxy;
    private static final String LOCAL_NAMED_ADDR = "127.0.0.1";
    private static final int LOCAL_NAMED_PORT = 793;
    private static final String REMOTE_NAMED_ADDR = "unamed.noah.baidu.com";
    private static final int REMOTE_NAMED_PORT = 793;
    private static final int DEFAULT_TIMEOUT_MS = 3000;
    private static final short MSG_TYPE_NAMING_REQ = 1;
    private static final short MSG_TYPE_AUTH_REQ = 2;
    private static final short MSG_TYPE_NAMING_RESP = 3;
    private static final short MSG_TYPE_AUTH_RESP = 4;
    private static final short MSG_TYPE_CONF_REQ = 15;
    private static final short MSG_TYPE_CONF_RESP = 16;
    private static final int RET_CODE_SERVICE_NOTEXIST = -1;
    private static final int RET_CODE_BEYOND_THRESHOLD = -16;
    private static final int MIN_TIME_OUT = 500;
    private int connectTimeout = 1000;
    private int readTimeout = 3000;

    private BNSQueryAgentProxy(String bnsService) {
        this.bnsQueryProxy = BNSQueryProxy.proxy((String)bnsService);
    }

    private BNSQueryAgentProxy(BNSQueryProxy proxy) {
        Assert.notNull((Object)proxy, (String)"Property 'proxy' of type BNSQueryProxy is null ");
        this.bnsQueryProxy = proxy;
    }

    public static BNSQueryAgentProxy proxy() {
        return new BNSQueryAgentProxy("http://noah.baidu.com/webfoot/index.php");
    }

    public static BNSQueryAgentProxy proxy(String bnsServiceUrl) {
        return new BNSQueryAgentProxy(bnsServiceUrl);
    }

    public static BNSQueryAgentProxy proxy(BNSQueryProxy proxy) {
        return new BNSQueryAgentProxy(proxy);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.bnsQueryProxy.setConnectTimeout(connectTimeout);
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        this.bnsQueryProxy.setReadTimeout(readTimeout);
    }

    public Instance getInstanceByService(String serviceName, SelectionStrategy strategy) throws BNSException {
        return this.getInstanceByService(serviceName, strategy, this.readTimeout);
    }

    public Instance getInstanceByService(String serviceName, SelectionStrategy strategy, int timeout) throws BNSException {
        if (strategy == null) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "SelectionStrategy 'strategy' is null.");
        }
        List<Instance> instances = this.getInstanceByService(serviceName, timeout);
        return this.selectOneByStrategy(instances, strategy);
    }

    protected Instance selectOneByStrategy(List<Instance> instances, SelectionStrategy strategy) {
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        Instance ret = null;
        int decideValue = -1;
        for (Instance instance : instances) {
            int deciding = strategy.deciding(instance);
            if (deciding < 0) {
                deciding = 0;
            } else if (deciding > 100) {
                deciding = 100;
            }
            if (deciding == 100) {
                return instance;
            }
            if (deciding <= decideValue) continue;
            ret = instance;
            decideValue = deciding;
        }
        return ret;
    }

    public List<Instance> getInstanceByService(String serviceName) throws BNSException {
        return this.getInstanceByService(serviceName, this.readTimeout);
    }

    public List<Instance> getInstanceByService(String serviceName, int timeoutMs) throws BNSException {
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "serivce name is blank.");
        }
        int timeout = timeoutMs;
        if (timeoutMs < 500) {
            timeout = 500;
        }
        List instances = this.bnsQueryProxy.getInstances(serviceName, new int[]{0});
        return instances;
    }

    public Service getService(String serviceName) {
        return this.getService(serviceName, this.readTimeout);
    }

    public Service getService(String serviceName, int timeoutMs) {
        if (StringUtils.isEmpty((String)serviceName)) {
            throw new BNSException(BNSException.ErrorCode.BNS_INPUT_ERROR_PARAM, "serivce name is blank.");
        }
        int timeout = timeoutMs;
        if (timeoutMs < 500) {
            timeout = 500;
        }
        Service service = this.bnsQueryProxy.getService(serviceName);
        return service;
    }

    private void checkResponseCode(int responseCode) {
        if (responseCode != 0) {
            BNSException.ErrorCode errorCode;
            String msg = "";
            if (responseCode == -1) {
                errorCode = BNSException.ErrorCode.BNS_SERVICE_NOTEXIST;
            } else if (responseCode == -16) {
                errorCode = BNSException.ErrorCode.BNS_SERVICE_BEYOND_THRESHOLD;
            } else {
                errorCode = BNSException.ErrorCode.BNS_RET_UNKNOWN;
                msg = "Unkow retCode from naming-agent:" + errorCode;
            }
            throw new BNSException(errorCode, msg);
        }
    }

    protected byte[] doRequest(String host, int port, byte[] requestBodyBytes, short requestMsgType, short expectResponseType, int timeoutMs) throws BNSException {
        Socket socket = null;
        try {
            int timeout = timeoutMs > 0 ? timeoutMs : this.readTimeout;
            socket = SocketUtils.createSocket((String)host, (int)port, (int)this.connectTimeout, (int)timeout);
            socket.setReuseAddress(true);
            SocketUtils.writeSocket((Socket)socket, (byte[])this.getBNSMsgBytes(requestBodyBytes, requestMsgType));
            InputStream is = socket.getInputStream();
            byte[] byArray = this.readBNSMsg(is, expectResponseType);
            return byArray;
        }
        catch (Exception e) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, e.getMessage());
        }
        finally {
            try {
                if (SocketUtils.isSocketConnected(socket)) {
                    socket.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected byte[] getBNSMsgBytes(byte[] requestBodyBytes, short requestMsgType) throws IOException {
        BNSHead reqHead = new BNSHead();
        reqHead.id = requestMsgType;
        reqHead.version = 0;
        reqHead.log_id = new Random().nextInt();
        reqHead.body_len = requestBodyBytes.length;
        byte[] reqHeadByte = reqHead.toBytes();
        ByteBuffer byteBuffer = ByteBuffer.allocate(requestBodyBytes.length + reqHeadByte.length);
        byteBuffer.put(reqHeadByte);
        byteBuffer.put(requestBodyBytes);
        byte[] ret = byteBuffer.array();
        byteBuffer.clear();
        return ret;
    }

    protected byte[] readBNSMsg(InputStream is, short expectResponseType) throws IOException {
        int ret;
        byte[] respHeadByte = new byte[20];
        int readCount = is.read(respHeadByte, 0, 20);
        if (readCount != 20) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Bad BNSHead, not enough head len, got" + readCount);
        }
        BNSHead respHead = BNSHead.fromBytes((byte[])respHeadByte);
        if (respHead == null || respHead.magic_num != -76508268 || respHead.body_len < 0 || respHead.body_len > 0x1400000) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Bad BNSHead");
        }
        if (respHead.id != expectResponseType) {
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Not expected msg type, expect " + expectResponseType + ", but got" + respHead.id);
        }
        byte[] respBodyByte = new byte[respHead.body_len];
        for (readCount = 0; readCount < respHead.body_len; readCount += ret) {
            ret = is.read(respBodyByte, readCount, respHead.body_len - readCount);
            if (ret >= 0) continue;
            throw new BNSException(BNSException.ErrorCode.BNS_TALK_TO_AGENT_ERROR, "Shorter body than expected, expect " + respHead.body_len + "B, but got " + readCount + "B");
        }
        return respBodyByte;
    }

    public static String getLocalNamedAddress() {
        String localNamedAddress = LOCAL_NAMED_ADDR;
        String defaultGateway = BNSQueryAgentProxy.getDefaultGateway();
        String jpaasv2Host = null;
        try {
            jpaasv2Host = System.getenv(JPAAS_HOST_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jpaasv2Host != null && jpaasv2Host.length() > 0) {
            localNamedAddress = jpaasv2Host;
        } else if (defaultGateway != null && defaultGateway.startsWith(LOCAL_IP_STARTS)) {
            localNamedAddress = defaultGateway;
        }
        return localNamedAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDefaultGateway() {
        String defaultGateway = null;
        FileReader file = null;
        BufferedReader reader = null;
        try {
            file = new FileReader(PROC_NET_ROUTE_COMMAND);
            reader = new BufferedReader(file);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] tokens = line.split("\\s+");
                if (tokens.length <= 3) continue;
                if (!tokens[1].equals(DEFAULT_TOKEN)) continue;
                String gatewayHex = tokens[2];
                if (gatewayHex.length() == 8) {
                    String string = defaultGateway = SocketUtils.hexStringIp2DottedIp((String)gatewayHex);
                    return string;
                }
                String string = null;
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), e.getCause());
            String string = null;
            return string;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), e.getCause());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), e.getCause());
                }
            }
        }
        return defaultGateway;
    }

    public List<Instance> queryInstances(String serviceName) throws BNSException {
        return this.getInstanceByService(serviceName);
    }

    public BNSQueryProxy getBnsQueryProxy() {
        return this.bnsQueryProxy;
    }
}

