/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.driver4j.bns.spring;

import com.baidu.driver4j.bns.BNSCallback;
import com.baidu.driver4j.bns.BNSCallbackProxy;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BNSCallbackProxyBean
extends BNSCallbackProxy
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BNSCallbackProxyBean.class.getName());
    private ApplicationContext applicationContext;
    private boolean autoRegister = true;

    public void destroy() throws Exception {
        this.stop();
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
        if (this.autoRegister) {
            LOGGER.info("Starting auto register action for BNSCallback class type.");
            Map bnsCallbacks = this.applicationContext.getBeansOfType(BNSCallback.class);
            if (bnsCallbacks != null) {
                for (Map.Entry next : bnsCallbacks.entrySet()) {
                    LOGGER.info("Auto register callback bean of bean name '" + (String)next.getKey() + "'");
                    this.register((BNSCallback)next.getValue());
                }
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    protected Map<String, BNSCallback> getCallbackMapping() {
        return super.getCallbackMapping();
    }
}

